#!/usr/bin/env python3
#
# GlobalChem - Electrophillic Warheads For Kinases
#
# ------------------------------------------------

class ElectrophilicWarheadsForKinases(object):

    def __init__(self):

        self.name = 'electrophilic_warheads_for_kinases'

    @staticmethod
    def get_smiles():

        smiles = {
            'methylacrylamide': 'CNC(C=C)=O',
            'methyl acrylate': 'COC(C=C)=O',
            'methyl propiolate' :'COC(C#C)=O',
            '2-cyanoacrylamide': 'N#CC(C(N)=O)=C',
            'n-methylmaleimide' :'CN1C(C=CC1=O)=O',
            'n-ethylmaleimide' :'O=C(C=CC1=O)N1CC',
            'crotonamide': r'C/C=C/C(N)=O',
            'ethyl crotonate': r'C/C=C/C(OCC)=O',
            'crotononitrile' : r'C/C=C/C#N',
            'methyl methylpropiolate': 'CC#CC(OC)=O',
            'isothiocyanatomethane': 'CN=C=S',
            'isothiocyanatoethane': 'CCN=C=S',
            'prop-1-ene': 'CC=C',
            'prop-1-yne': 'CC#C',
            'acetonitrile': 'CC#N',
            'tert-butyl (Z)-2-ethylidenehydrazine-1-carboxylate' : r'C/C=N/\/NC(OC(C)(C)C)=O',
            'n-methylchloroacetamide': 'CNC(CCl)=O',
            'n-methyl-2-chloropropanamide': 'CNC(C(C)Cl)=O',
            'n-methyl-2-bromopropanamide': 'CNC(C(C)Br)=O',
            'bromoacetone': 'CC(CBr)=O',
            '2-methyloxirane': 'CC1OC1',
            'fluoromethane': 'CF',
            'methylsulfane': 'CS',
            'aldehyde': 'CC=O'
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'methylacrylamide': '[#6]-[#7]-[#6](-[#6]=[#6])=[#8]',
            'methyl acrylate': '[#6]-[#8]-[#6](-[#6]=[#6])=[#8]',
            'methyl propiolate': '[#6]-[#8]-[#6](-[#6]#[#6])=[#8]',
            '2-cyanoacrylamide': '[#7]#[#6]-[#6](-[#6](-[#7])=[#8])=[#6]',
            'n-methylmaleimide': '[#6]-[#7]1-[#6](-[#6]=[#6]-[#6]-1=[#8])=[#8]',
            'n-ethylmaleimide': '[#8]=[#6]1-[#6]=[#6]-[#6](=[#8])-[#7]-1-[#6]-[#6]',
            'crotonamide': '[#6]/[#6]=[#6]/[#6](-[#7])=[#8]',
            'ethyl crotonate': '[#6]/[#6]=[#6]/[#6](-[#8]-[#6]-[#6])=[#8]',
            'crotononitrile': '[#6]/[#6]=[#6]/[#6]#[#7]',
            'methyl methylpropiolate': '[#6]-[#6]#[#6]-[#6](-[#8]-[#6])=[#8]',
            'isothiocyanatomethane': '[#6]-[#7]=[#6]=[#16]',
            'isothiocyanatoethane': '[#6]-[#6]-[#7]=[#6]=[#16]',
            'prop-1-ene': '[#6]-[#6]=[#6]',
            'prop-1-yne': '[#6]-[#6]#[#6]',
            'acetonitrile': '[#6]-[#6]#[#7]',
            'tert-butyl (Z)-2-ethylidenehydrazine-1-carboxylate': '[#6]/[#6]=[#7]\[#7]-[#6](-[#8]-[#6](-[#6])(-[#6])-[#6])=[#8]',
            'n-methylchloroacetamide': '[#6]-[#7]-[#6](-[#6]-[#17])=[#8]',
            'n-methyl-2-chloropropanamide': '[#6]-[#7]-[#6](-[#6](-[#6])-[#17])=[#8]',
            'n-methyl-2-bromopropanamide': '[#6]-[#7]-[#6](-[#6](-[#6])-[#35])=[#8]',
            'bromoacetone': '[#6]-[#6](-[#6]-[#35])=[#8]',
            '2-methyloxirane': '[#6]-[#6]1-[#8]-[#6]-1',
            'fluoromethane': '[#6]-[#9]',
            'methylsulfane': '[#6]-[#16]',
            'aldehyde': '[#6]-[#6]=[#8]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'methylacrylamide': '00000000000000000000000000000000010000000000000000000000000000000001000000000000000000000000000000000000000001000000000000000000100000000010000000000000000001000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000001000000000000000000000000000000000000000000000010010000000000000000000000000000000000010000000000000000000000001000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000',
            'methyl acrylate': '00000000000000000000000000000000010000000000000001000000000000000000000000000000000000000000000000000000000001000000000000000000100000000010000000000000000000000000001000000000001000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000100000000000010000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000100000000000',
            'methyl propiolate': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000000000000010000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000100000000000010000000000000000000000001001000000000000000000000000000000100000000000000000000000000000000000000000000000000010000000000000000000001000000000000000000000000000000000000000000000000000000010010000000000000000000000000000000000000000000000000',
            '2-cyanoacrylamide': '00000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010100000010000010000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000010001000000000000000000000000000000000000000000010010000000000000000010000000000000000000010100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000010',
            'n-methylmaleimide': '00000000000000000000000000000000010100000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000100000010000000000000001000000000000000000100000100000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000001000000000100000000000000000000000000',
            'n-ethylmaleimide': '00000000000000000000000000100000011100100000000000000000000000000000000000001000100000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000001000000000000000010000000000000000000100000010000000000000001000000000000000000100000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'crotonamide': '00000000000000000000000000000001010000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000010100000010000000000000000000000000100000000100000000000000000000000001000001000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000100000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000',
            'ethyl crotonate': '00000000000000000000000000000001010000000000000001001000000100000000000000000000100000000000000000000000000000000000000000000000000000000010000000010000000000000000000000000000000000110010000000000000000000001000001000000000000000000000000000000000000000000000000000000000000000000000000000000011000000010000000000000000000000000000100000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000',
            'crotononitrile': '00000000000000000000000000000000010001000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000010000000000000000000100000000000000000000000001000000000000000000000000000000000000000000000000000000100000000000000100000000000000000000000000000000000000000000000000000100000000001000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'methyl methylpropiolate': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000010000000000001000010000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000001001000000000000000000000000000000100000000000000000000010000000000000000000000001000010000000000000000000000100000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000',
            'isothiocyanatomethane': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000010000000000000000000001000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000100000000000100000000000000000000000000000000000000000000000000000000000000000000',
            'isothiocyanatoethane': '00000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000001000000000000000000000000000000000000000000000000000000000000000010000000000000000001000000000000000000000000000001010000000000000000000001000000000000000000000000000000000000000000000000000000000010010000000000000000000000000001000000000000010000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'prop-1-ene': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000001001000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'prop-1-yne': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000001000000000000000000000000000000000000000000000000000000001010000000000000000000000000000000000000000000000000',
            'acetonitrile': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000',
            'n-methylchloroacetamide': '00000000000000000000000000000000010000000100001000000000000000000000000000000000100001000000000000000000000000000000000000000000100000000010000000010000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000010000000000000000000000000000000000010000000000000000000000001000000000000010000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000',
            'n-methyl-2-chloropropanamide': '01000000000000000000000000000000010000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000100000000010000000011000000000000000000000000000100000000000000100000000000000000000000000000000000010000000000000000000000000000000000000000000000000000001000000000001000000000000000000000000000000000000000000000000010000000000000000000000000000000000010000000000000000000010001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'n-methyl-2-bromopropanamide': '01000000000000000000000000000000010000000000000000000000000001000000000000000000000000001000000000000000000000000000000000000000100000000010000000000000000000000000000000000000000000000000001100000000000000000000000010000000000000000000000000000000100000000000000000000000000000000001000000000001000000000000000000000000000000000000000000000000010000000000000100000000000000000000010000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'bromoacetone': '00000000001000100000000000000000010000000000000000000000000000000000000000000000110000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000100000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000',
            '2-methyloxirane': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000100000000010000000000000000000000000000000000000000000000000000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000',
            'fluoromethane': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'methylsulfane': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000',
            'aldehyde': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000',
        }

        return bit_vector