#!/usr/bin/env python3
#
# GlobalChem - Vitamins
#
# -----------------------------------

class Vitamins(object):

    def __init__(self):

        self.name = 'vitamins'

    @staticmethod
    def get_smiles():

        smiles = {
            'vitamin A': 'CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CCO)C)C',
            'vitamin C': 'C(C(C1C(=C(C(=O)O1)O)O)O)O',
            'vitamin D': 'CC(C)CCCC(C)C1CCC2C1(CCCC2=CC=C3CC(CCC3=C)O)C',
            'vitamin E': 'CC1=C(C2=C(CCC(O2)(C)CCCC(C)CCCC(C)CCCC(C)C)C(=C1O)C)C',
            'vitamin K': 'CC1=C(C(=O)C2=CC=CC=C2C1=O)CC=C(C)CCCC(C)CCCC(C)CCCC(C)C',
            'thiamine': 'OCCC1=C(C)[N+](CC2=CN=C(C)N=C2N)=CS1',
            'riboflavin': 'OC[C@H](O)[C@H](O)[C@H](O)CN(C(C=C1C)=C(C=C1C)N=C2C(N3)=O)C2=NC3=O',
            'niacin': 'C1=CC(=CN=C1)C(=O)O',
            'pantothenic acid': 'CC(C)(CO)C(C(=O)NCCC(=O)O)O',
            'biotin': 'C1C2C(C(S1)CCCCC(=O)O)NC(=O)N2',
            'b6': 'CC1=NC=C(C(=C1O)CO)CO',
            'b12': 'CC1=CC2=C(C=C1C)N(C=N2)C3C(C(C(O3)CO)OP(=O)(O)OC(C)CNC(=O)CCC4(C(C5C6(C(C(C(=C(C7=NC(=CC8=NC(=C(C4=N5)C)C(C8(C)C)CCC(=O)N)C(C7(C)CC(=O)N)CCC(=O)N)C)[N-]6)CCC(=O)N)(C)CC(=O)N)C)CC(=O)N)C)O',
            'folate': 'C1=CC(=CC=C1C(=O)NC(CCC(=O)O)C(=O)O)NCC2=CN=C3C(=N2)C(=O)NC(=N3)N',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'vitamin A':'[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]-[#8])-[#6])-[#6]',
            'vitamin C':'[#6](-[#6](-[#6]1-[#6](=[#6](-[#6](=[#8])-[#8]-1)-[#8])-[#8])-[#8])-[#8]',
            'vitamin D':'[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6]-[#6]-2=[#6]-[#6]=[#6]1-[#6]-[#6](-[#6]-[#6]-[#6]-1=[#6])-[#8])-[#6]',
            'vitamin E':'[#6]-[#6]1:[#6](:[#6]2:[#6](-[#6]-[#6]-[#6](-[#8]-2)(-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]):[#6](:[#6]:1-[#8])-[#6])-[#6]',
            'vitamin K':'[#6]-[#6]1=[#6](-[#6](=[#8])-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#6]-1=[#8])-[#6]-[#6]=[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]',
            'thiamine':'[#8]-[#6]-[#6]-[#6]1:[#6](-[#6]):[#7+](-[#6]-[#6]2:[#6]:[#7]:[#6](-[#6]):[#7]:[#6]:2-[#7]):[#6]:[#16]:1',
            'riboflavin':'[#8]-[#6]-[#6@H](-[#8])-[#6@H](-[#8])-[#6@H](-[#8])-[#6]-[#7]1:[#6]2:[#6]:[#6](-[#6]):[#6](:[#6]:[#6]:2:[#7]:[#6]2:[#6](:[#7H]:[#6](:[#7]:[#6]:1-2)=[#8])=[#8])-[#6]',
            'niacin':'[#6]1:[#6]:[#6](:[#6]:[#7]:[#6]:1)-[#6](=[#8])-[#8]',
            'pantothenic acid':'[#6]-[#6](-[#6])(-[#6]-[#8])-[#6](-[#6](=[#8])-[#7]-[#6]-[#6]-[#6](=[#8])-[#8])-[#8]',
            'biotin':'[#6]1-[#6]2-[#6](-[#6](-[#16]-1)-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8])-[#7]-[#6](=[#8])-[#7]-2',
            'b6':'[#6]-[#6]1:[#7]:[#6]:[#6](:[#6](:[#6]:1-[#8])-[#6]-[#8])-[#6]-[#8]',
            'b12':'[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#6]):[#7](:[#6]:[#7]:2)-[#6]1-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8]-[#15](=[#8])(-[#8])-[#8]-[#6](-[#6])-[#6]-[#7]-[#6](=[#8])-[#6]-[#6]-[#6]1(-[#6](-[#6]2-[#6]3(-[#6](-[#6](-[#6](=[#6](-[#6]4=[#7]-[#6](=[#6]-[#6]5=[#7]-[#6](=[#6](-[#6]-1=[#7]-2)-[#6])-[#6](-[#6]-5(-[#6])-[#6])-[#6]-[#6]-[#6](=[#8])-[#7])-[#6](-[#6]-4(-[#6])-[#6]-[#6](=[#8])-[#7])-[#6]-[#6]-[#6](=[#8])-[#7])-[#6])-[#7-]-3)-[#6]-[#6]-[#6](=[#8])-[#7])(-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#8]',
            'folate':'[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6](=[#8])-[#7]-[#6](-[#6]-[#6]-[#6](=[#8])-[#8])-[#6](=[#8])-[#8])-[#7]-[#6]-[#6]1:[#6]:[#7]:[#6]2:[#6](:[#7]:1):[#6](=[#8]):[#7H]:[#6](:[#7]:2)-[#7]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'vitamin A': '00001000000000000000000000000001010010001000100000000001000000010000000000000000100000000010000000000000001000010000000000000000001000000010000000000000000000000000000000000100000000100010000000000000001000100000000000000010000000000000000000000000001000000001000010000000000000000000000000010001000000000000000001000000000101000000000000000000000000000000100000000000000000000000000000000000000000000000000000000010000011000000000010000000010010000000000000000000000000000000000100000000000000000000100001000000',
            'vitamin C': '01001000000000000000100000000000000000000000000000000000000000001010000010000000100000000000000000000000000000000000000000000000000000000010000010000000000000000001000000000000000000000000000000000000000000000000000000000010000100000000001000000000000000000000000000000000000000000010000000000001000000000000000000100000000000000000000000000000000100000000100000000100000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000010000000000000000000000100010000000000000000000010000',
            'vitamin D': '01001000100000000000000000000000010110000000000000000000000000000000000000000010100000000000000000100000000000000000000010000000000001000110000000100000000001000000001000000000000000100000000000000000001000100000000000000000000100010100000001010000001000000000000000000000100000000001000000000001000101000000000100000000000010010000000010100010100000000000100000000000000000010010000000000000000100000000001001000010000000000000000000000000000010000000010000000100000000000000001000000000001000000001000000010000',
            'vitamin E': '01000000000000000000000000000001010010000000000000000000000000000010000000000000100000010000000000000000000000001000001000000000000000000010000010100000000000001000000000100000000000000010010000000000001000000000000000000000000111000000100000010000001010000010001000000010000000000001000000000001000000000000000100000000000010000000000000000000100000000000100001000000000000010000000000000000000000000000001000000010000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000',
            'vitamin K': '01000000000000000000000000001000010000000000000000000000000000001000010000000001100000010000000000000001000000010000001000000000000001000010000000100000000000000000000001000001001000100010000100000010000000000000001000000000000100000000000000010000000000000000000000000000000000000001000000000001000000000000000100100000000010000000000001000000000000001000100000000000000000010000000001000000000000000000001000000000000000000100000000000000000000001000100000000000000000001001000100000000000000000000000001000000',
            'thiamine': '00010000000000000000000000100001010000000000100000000000000000000000000000000001100000000000000000000010000000000000000000000000000000000000000000010000000000000001000000000000000100000010000100001000000000000000010000010010000000000000100100000000001000000000000000000000000000000000100000000001000000001000000000000001000001001000000001000010000000000001100000000000000000000010000000000000000000000000000000000100000000000000100001010000000000000000000001000001000000000100000000000000000001000000000000000001',
            'riboflavin': '01000000000000000000000000000000010000100100010000000000000000100000000001000001100000000010000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000000011000000100000000000000100000000000010000100000000011000000000010000000000100000000000001000000000000000100001000000000000000000100101000100000000000001000000000000000000100000010001011000001011000000100000000010000000000000000000000000010000000000000000000000000000001000000000000000000000000000100000000000000000000000100000',
            'niacin': '00000000000000000001000000000000000000000000000000100000000000001001000000000000000000000000000000000000000000000010000000000000000000000010010000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000010000001000000000000000000100001000000000000000010010000000100000000000000000000000000000000000010000000000100000000000100000010000000000000000000000000000000000000000000000000000001',
            'pantothenic acid': '01000000000000000000000000001000010000000000000000000000000001000000000000000000100000000000000000000000000000000011000000000000100000000010000000000000000100000000000000000000000000000000000000000100010000000000000000000010000100000000000000000000000000000000000100000000000000000000000000000001000000010000000000000000000000000000000000000000000000000000001000010000000000000000010000000100100000000000000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000000000000000100000',
            'biotin': '00000000000000000000000000001000000000000000000000000000001000000000000000000000100000100010000000000000000000000000000000000000000000000010000100000000000000000001000000000000000000000000000000000000010000000000000000000000000000100000000000010000000001000001100100000000000000000000000000001001000101000000000000100000100000000000001000000000000000000000100000000000000000010000010000000100000000100000000000000010000000000000000100000010000000000000000000000001000000010000000000000010000000000000000000010000',
            'b6': '00000000000000000000000000000000010001000000000000100000000000000010000000000000100000000000100000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000010000001000000001000000010000000000010000000000000000000000010000000000000000000000000000000000000100000000001000000000000000000000000000001000000000001000000000000000000100000000000000000000010000000000000000000000000000001000000000000000000100000000000000000000000000000000000000000000000000000000000000000000010000000000001',
            'b12': '11000000010001000010000000001000111110000100010000000100000000000100110011010000110010000000001000100001101000001000000000000000101100000010100011010000100100000000000000000000011000110010100010100110010000000000000100010010010010000101000000000000011000000000000010000000000001000001010000000001000000100000001010000100100000000000101001000000000010000000100000110001001000000010010001000100000000000000000010010111010010010000110000000000000010000000001000000001000010000010000011001011110010000000000010110010',
            'folate': '01000000000000000000000000001000000000000000000000000000000000100000000000000010100000011010000001000000000000000000010001000000110000000010000000010000000000000100000000000000000000000101100100000000010000000100101000000000100100000000001000001000000000010000000100000000000000000000000000000001000000000000100000100001010000000001001001100001000000000000100001000000000000000010010000000100100000000100000000010000000000010000100001000000000100000000000000000000000000000000000000000110000000000001000000001001',
        }

        return bit_vector