#!/usr/bin/env python3
#
# GlobalChem - Schedule Five
#
# -----------------------------------

class ScheduleFive(object):

    def __init__(self):

        self.name = 'schedule_five'

    @staticmethod
    def get_smiles():

        smiles = {
            'eluxadoline': 'CC1=CC(=CC(=C1CC(C(=O)N(CC2=CC(=C(C=C2)OC)C(=O)O)C(C)C3=NC=C(N3)C4=CC=CC=C4)N)C)C(=O)N',
            'pyrovalerone': 'CCCC(C(=O)C1=CC=C(C=C1)C)N2CCCC2',
            'brivaracetam': 'CCCC1CC(=O)N(C1)C(CC)C(=O)N',
            'cenobamate': 'C1=CC=C(C(=C1)C(CN2N=CN=N2)OC(=O)N)Cl',
            'ezogabine': 'CCOC(=O)NC1=C(C=C(C=C1)NCC2=CC=C(C=C2)F)N',
            'lacosamide': 'CC(=O)NC(COC)C(=O)NCC1=CC=CC=C1',
            'lasmiditan': 'CN1CCC(CC1)C(=O)C2=NC(=CC=C2)NC(=O)C3=C(C=C(C=C3F)F)F',
            'pregabalin': 'CC(C)CC(CC(=O)O)CN',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'eluxadoline': '[#6]-[#6]1:[#6]:[#6](:[#6]:[#6](:[#6]:1-[#6]-[#6](-[#6](=[#8])-[#7](-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8]-[#6])-[#6](=[#8])-[#8])-[#6](-[#6])-[#6]1:[#7]:[#6]:[#6](:[#7H]:1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)-[#7])-[#6])-[#6](=[#8])-[#7]',
            'pyrovalerone': '[#6]-[#6]-[#6]-[#6](-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6])-[#7]1-[#6]-[#6]-[#6]-[#6]-1',
            'brivaracetam': '[#6]-[#6]-[#6]-[#6]1-[#6]-[#6](=[#8])-[#7](-[#6]-1)-[#6](-[#6]-[#6])-[#6](=[#8])-[#7]',
            'cenobamate': '[#6]1:[#6]:[#6]:[#6](:[#6](:[#6]:1)-[#6](-[#6]-[#7]1:[#7]:[#6]:[#7]:[#7]:1)-[#8]-[#6](=[#8])-[#7])-[#17]',
            'ezogabine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#7]-[#6]1:[#6](:[#6]:[#6](:[#6]:[#6]:1)-[#7]-[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#9])-[#7]',
            'lacosamide': '[#6]-[#6](=[#8])-[#7]-[#6](-[#6]-[#8]-[#6])-[#6](=[#8])-[#7]-[#6]-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'lasmiditan': '[#6]-[#7]1-[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#6](=[#8])-[#6]1:[#7]:[#6](:[#6]:[#6]:[#6]:1)-[#7]-[#6](=[#8])-[#6]1:[#6](:[#6]:[#6](:[#6]:[#6]:1-[#9])-[#9])-[#9]',
            'pregabalin': '[#6]-[#6](-[#6])-[#6]-[#6](-[#6]-[#6](=[#8])-[#8])-[#6]-[#7]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'eluxadoline': '11000000000000100000000100000100010000000000000000000000000000001000000000000001100000000010001000000000000001000000000010000000000000001010100000010000000100000000001000010001000000010010000100000000000000000100001010100000100000000001000000000000010000000000000000000000001001000001001000000001000010000000011001000001000001000101000001000000000000000100100001010001010000010010110000000100000000000000000000000000010000001100100000100000000000000000010110011000000000000000000000000000000000000010000000010001',
            'pyrovalerone': '01001000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000010100000000000000000000100000000000000000000000010000000000000000000000000001000001000000100000001000001000000000000000000000000000000000000100010000110000011000000000000000000000000000000000000000001000000000000010000100001000000000000000000010010100001000000000000000000000010000000010000000000000000000000000000000010000010010000000000000000000000000000000000000100000000',
            'brivaracetam': '01000000100000000000000000001100010000000000000000000000000000000000000001000000100000000000000100000000000000001000000000100000000000000010100000010000000000000000010100000000000000000000100000000000000000000000000000000000000100010000000000000000001000000000000000000000000000000010001000000011001000000000000000100000100000000000000000000000000000000000100000000000000000000000010000000000000010000000000000000010000000010000000000000000000000000000000000000000000000000000000000000000000000000000000100010000',
            'cenobamate': '01000000000000000000000000000000000000000001000001000000000000001000010000000000100000000000000000000000000000000000000000000000000000001010100000010000000000000000000000000001000000010000000000000000010000000000001000100000010000000000010000000001000000000010000000000000000000000100000000000001000000000000000001000000000000000000000001000000000000000000100000000010000000000010010000100000000001000000000000000000000001010001000000000000000000001000000000000011000000000000000000000001010000100000000000010000',
            'ezogabine': '00000000000000000000000000000000010000000000000000000000000000000000000000000000100000010010000000000000000000000000000000000010100000100010000000010000000000000000000000000000000001010011000100000000100000000000001000100010000000000000000000000000000000010001000000000000000000001000000000000011000000101000001000000000100000000001000001000000000000000000100000010000000000000000010000100000100000100000000000000000000000000000000001000000000000000010000000000000000010010000000000000000000000000000010000000000',
            'lacosamide': '01000000000001000000000000000000010001000010000000000000000001001000000000000000100000000000000000000000000000000000011000000010100000000010000000000000000000000000000000000101000000010000000000000100000000000000001000100000100000000000000000000100000000010000000000000000000000000000001000000001000000000000000000000000000000001100000001000000000000000000100000000000000000000000010000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000011000000',
            'lasmiditan': '00000100000000010000000000000000010000000000001000000000000000001000000000110000000000000000000000000000000100000000000001000000100000100010000000000000100000000000000000000000000000000001000000000000000000010000101000000000000000000000000000100000000000010000000000000000100000001000000000000001000001001000000000010001000000000000000001000001000000000000100000010000000000000010010000000000110000000000000000000010000000010000000000000000000000000000000010000010000000110000000001000010000000000100000000010000',
            'pregabalin': '01000000000000000000000000000000010100000000000000000000000000000000000000000000100000000000000000000000000000000000010000000000000000000010000000010000000000100000000010000000000000000001000000000000010000000000000000000000000000000000000000000001000000000000000000100000000000000001000000000001000000000000000100000000000000000000000000000000000000000000000000000000000001000000010000000100000010000000000000000000000000000000000000000000000000000000000000100000000001000000000000000000000000000000000000000000',
        }

        return bit_vector