# -*- coding:utf-8 -*-
"""
@Author  :   g1879
@Contact :   g1879@qq.com
"""
from pathlib import Path
from typing import Union, List

from selenium.webdriver.chrome.options import Options


class DriverOptions(Options):

    def __init__(self, read_file: bool = True, ini_path: Union[str, Path] = None):
        self.ini_path: str = ...
        self._driver_path: str = ...
        self._user_data_path: str = ...
        self._download_path: str = ...

    @property
    def driver_path(self) -> str: ...

    @property
    def download_path(self) -> str: ...

    @property
    def chrome_path(self) -> str: ...

    @property
    def browser_path(self) -> str: ...

    @property
    def user_data_path(self) -> str: ...

    # -------------重写父类方法，实现链式操作-------------
    def add_argument(self, argument: str) -> DriverOptions: ...

    def set_capability(self, name: str, value: str) -> DriverOptions: ...

    def add_extension(self, extension: str) -> DriverOptions: ...

    def add_encoded_extension(self, extension: str) -> DriverOptions: ...

    def add_experimental_option(self, name: str, value: Union[str, int, dict, List[str]]) -> DriverOptions: ...

    # -------------重写父类方法结束-------------

    def save(self, path: str = None) -> str: ...

    def save_to_default(self) -> str: ...

    def remove_argument(self, value: str) -> DriverOptions: ...

    def remove_experimental_option(self, key: str) -> DriverOptions: ...

    def remove_all_extensions(self) -> DriverOptions: ...

    def set_argument(self, arg: str, value: Union[bool, str]) -> DriverOptions: ...

    def set_timeouts(self, implicit: float = None, pageLoad: float = None, script: float = None) -> DriverOptions: ...

    def set_headless(self, on_off: bool = True) -> DriverOptions: ...

    def set_no_imgs(self, on_off: bool = True) -> DriverOptions: ...

    def set_no_js(self, on_off: bool = True) -> DriverOptions: ...

    def set_mute(self, on_off: bool = True) -> DriverOptions: ...

    def set_user_agent(self, user_agent: str) -> DriverOptions: ...

    def set_proxy(self, proxy: str) -> DriverOptions: ...

    def set_page_load_strategy(self, value: str) -> DriverOptions: ...

    def set_paths(self,
                  driver_path: Union[str, Path] = None,
                  chrome_path: Union[str, Path] = None,
                  browser_path: Union[str, Path] = None,
                  local_port: Union[int, str] = None,
                  debugger_address: str = None,
                  download_path: str = None,
                  user_data_path: str = None,
                  cache_path: str = None) -> DriverOptions: ...

    def as_dict(self) -> dict: ...


def chrome_options_to_dict(options: Union[dict, DriverOptions, Options, None, bool]) -> Union[dict, None]: ...
