from __future__ import absolute_import, division, print_function, unicode_literals

# don't do `from builtins import str`
from setuptools import setup
from io import open
from itertools import chain

# nltk.download("punkt")

with open("README.md", "r", encoding="utf-8") as fr:
	long_description = fr.read()

extras_require = {
	"args": [],
	"algorithms": [],
	"atomic": [],
	"binary": [],
	"concurrency": [],
	"constants_physics": [],
	"constants_video": [],
	"csv": [],
	"datetime": [],
	"debug": [],
	"dict": [],
	"datastructures": [],
	"error": [],
	"exceptions": [],
	"factorial": [],
	"func": [],
	"file": [],
	"filesystem": [],
	"geometry": [],
	"hash": [],
	"iter": [],
	"imdb": [],
	"indexing": [],
	"latex": [],
	"math": [],
	"mongo": [],
	"object": [],
	"ops": [],
	"os": ["ctypes-windows-sdk>=0.0.4; sys_platform == 'win32'"],
	"pickle": [],
	"pandas": [],
	"profile": [],
	"rand": [],
	"ringlist": [],
	"search": [],
	"sequence": [],
	"set": [],
	"signal": [],
	"sort": [],
	"sql": [],
	"statistics": [],
	"stdio": [],
	"string": [],
	"sudoku": [],
	"sqlite": [],
	"test": [],
	"time": [],
	"typing": [],
	"text": [],
	"twitch": [],
	"url": [],

	# "browscap": ["re2"], # unfinished
	"cholesky": ["numpy", "numba"],
	"config": ["jsonschema", "sortedcontainers"],
	"downloadmanager": ["aiohttp>=0.16.3", "orderedset"],
	"encoder": ["numpy", "nltk"],
	"html": ["beautifulsoup4"],
	"http": ["requests"],
	"http2": ["hyper"],
	"image": ["numpy"],
	"json": ["jsonschema"],
	"lda": ["numpy", "nltk"],
	"metrics": ["numpy"],
	"mp4": ["setuptools"],
	"multihash": ["rhash"],
	"net": ["netifaces"],
	"nlp": ["nltk"],
	"regression": ["numpy"],
	"resizing": ["numpy", "opencv-python", "scikit-learn"],
	"scene_change_detection": ["numpy"],
	"tls": ["cryptography", "pyOpenSSL>=17.5.0"],
	"torrent": ["bencode.py>=2.0.0"],  # bencoding ?
	"videofile": ["opencv-python", "av"],
	"win32": ["wmi", "pypiwin32"],
	"widgets": ["wxPython"],
	"xsl": ["lxml"],

	# helpers for specific packages
	"aria": ["aria2p", "requests"],
	"av": ["av"],
	"cv": ["opencv-python", "numpy"],
	"flask": ["flask", "werkzeug>=0.11.11"],
	"gensim": ["gensim>=3.3.0", "numpy"],
	"msgpack": ["msgpack>=0.6.0"],
	"mediainfo": ["pymediainfo"],
	"numpy": ["numpy"],
	"numba": ["numba"],
	"nltk": ["nltk"],
	"networkx": ["networkx"],
	"pdf": ["PyPDF2"],
	"pillow": ["pillow", "piexif"],
	"powerpoint": ["python-pptx"],
	"scipy": ["numpy", "scipy"],
	"toml": ["toml"],
	"torch": ["torch"],
	"twisted": ["twisted"],
	"tensorflow": ["tensorflow"],
}

extras_require["all"] = sorted(set(chain.from_iterable(extras_require.values())))

setup(
	author="Dobatymo",
	name="genutility",
	version="0.0.36",
	url="https://github.com/Dobatymo/genutility",
	description="A collection of various Python utilities",
	long_description=long_description,
	long_description_content_type="text/markdown",
	classifiers=[
		"Programming Language :: Python :: 2",
		"Programming Language :: Python :: 3",
		"License :: OSI Approved :: ISC License (ISCL)",
		"Operating System :: OS Independent",
		"Topic :: Utilities",
	],
	packages=["genutility", "genutility/compat", "genutility/fileformats", "genutility/hardware", "genutility/twothree"],
	package_data={str("genutility"): ["data/*.tsv"]},
	python_requires=">=2.7",
	install_requires=[
		"future",
		"typing;python_version<'3.5'",
		"scandir;python_version<'3.5'",
		"pathlib2;python_version<'3.4'",
		"mock;python_version<'3.3'",
		"contextlib2;python_version<'3.3'",
	],
	extras_require=extras_require,
	use_2to3=False
)
