/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntegerObjectPropertyAssertionAxiom
implements ComplexIntegerAxiom {
    private final Set<Integer> individualsInSignature;
    private final int object;
    private final IntegerObjectPropertyExpression property;
    private final int subject;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    IntegerObjectPropertyAssertionAxiom(IntegerObjectPropertyExpression objectProp, int subjectInd, int objectInd, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(objectProp);
        Objects.requireNonNull(annotations);
        this.property = objectProp;
        this.subject = subjectInd;
        this.object = objectInd;
        HashSet<Integer> individualsInSignature = new HashSet<Integer>();
        individualsInSignature.add(this.subject);
        individualsInSignature.add(this.object);
        this.individualsInSignature = Collections.unmodifiableSet(individualsInSignature);
        this.annotations = annotations;
        this.hashCode = this.property.hashCode() + 31 * (this.subject + 31 * (this.object + 31 * this.annotations.hashCode()));
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerObjectPropertyAssertionAxiom) {
            IntegerObjectPropertyAssertionAxiom other = (IntegerObjectPropertyAssertionAxiom)obj;
            ret = this.getProperty().equals(other.getProperty()) && this.getSubject().equals(other.getSubject()) && this.getObject().equals(other.getObject()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.unmodifiableSet(this.individualsInSignature);
    }

    public Integer getObject() {
        return this.object;
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return this.getProperty().getObjectPropertiesInSignature();
    }

    public IntegerObjectPropertyExpression getProperty() {
        return this.property;
    }

    public Integer getSubject() {
        return this.subject;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("ObjectPropertyAssertion");
        sbuf.append("(");
        sbuf.append(this.getProperty().toString());
        sbuf.append(" ");
        sbuf.append(this.getSubject().toString());
        sbuf.append(" ");
        sbuf.append(this.getObject().toString());
        sbuf.append(")");
        return sbuf.toString();
    }
}

