/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntegerSubClassOfAxiom
implements ComplexIntegerAxiom {
    private final Set<Integer> classesInSignature;
    private final Set<Integer> objectPropertiesInSignature;
    private final IntegerClassExpression subClass;
    private final IntegerClassExpression superClass;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    IntegerSubClassOfAxiom(IntegerClassExpression subClExpr, IntegerClassExpression superClExpr, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(subClExpr);
        Objects.requireNonNull(superClExpr);
        Objects.requireNonNull(annotations);
        this.subClass = subClExpr;
        this.superClass = superClExpr;
        HashSet<Integer> classesInSignature = new HashSet<Integer>();
        classesInSignature.addAll(this.subClass.getClassesInSignature());
        classesInSignature.addAll(this.superClass.getClassesInSignature());
        this.classesInSignature = Collections.unmodifiableSet(classesInSignature);
        HashSet<Integer> objectPropertiesInSignature = new HashSet<Integer>();
        objectPropertiesInSignature.addAll(this.subClass.getObjectPropertiesInSignature());
        objectPropertiesInSignature.addAll(this.superClass.getObjectPropertiesInSignature());
        this.objectPropertiesInSignature = Collections.unmodifiableSet(objectPropertiesInSignature);
        this.annotations = annotations;
        this.hashCode = this.subClass.hashCode() + 31 * (this.superClass.hashCode() + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerSubClassOfAxiom) {
            IntegerSubClassOfAxiom other = (IntegerSubClassOfAxiom)obj;
            ret = this.getSubClass().equals(other.getSubClass()) && this.getSuperClass().equals(other.getSuperClass()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.unmodifiableSet(this.classesInSignature);
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.unmodifiableSet(this.objectPropertiesInSignature);
    }

    public IntegerClassExpression getSubClass() {
        return this.subClass;
    }

    public IntegerClassExpression getSuperClass() {
        return this.superClass;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubClassOf");
        sbuf.append("(");
        sbuf.append(this.getSubClass().toString());
        sbuf.append(" ");
        sbuf.append(this.getSuperClass().toString());
        sbuf.append(")");
        return sbuf.toString();
    }
}

