/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class IntegerSubPropertyChainOfAxiom
implements ComplexIntegerAxiom {
    private final int hashCode;
    private final Set<Integer> objectPropertiesInSignature;
    private final List<IntegerObjectPropertyExpression> propertyChain;
    private final IntegerObjectPropertyExpression superProperty;
    private final Set<IntegerAnnotation> annotations;

    IntegerSubPropertyChainOfAxiom(List<IntegerObjectPropertyExpression> chain, IntegerObjectPropertyExpression superProp, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(chain);
        Objects.requireNonNull(superProp);
        Objects.requireNonNull(annotations);
        this.propertyChain = chain;
        this.superProperty = superProp;
        HashSet<Integer> objectPropertiesInSignature = new HashSet<Integer>();
        this.getPropertyChain().forEach(propertyExpr -> objectPropertiesInSignature.addAll(propertyExpr.getObjectPropertiesInSignature()));
        objectPropertiesInSignature.addAll(this.getSuperProperty().getObjectPropertiesInSignature());
        this.objectPropertiesInSignature = Collections.unmodifiableSet(objectPropertiesInSignature);
        this.annotations = annotations;
        this.hashCode = this.propertyChain.hashCode() + 31 * (this.superProperty.hashCode() + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerSubPropertyChainOfAxiom) {
            IntegerSubPropertyChainOfAxiom other = (IntegerSubPropertyChainOfAxiom)obj;
            ret = this.getPropertyChain().equals(other.getPropertyChain()) && this.getSuperProperty().equals(other.getSuperProperty()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.unmodifiableSet(this.objectPropertiesInSignature);
    }

    public List<IntegerObjectPropertyExpression> getPropertyChain() {
        return Collections.unmodifiableList(this.propertyChain);
    }

    public IntegerObjectPropertyExpression getSuperProperty() {
        return this.superProperty;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubObjectPropertyOf");
        sbuf.append("(");
        sbuf.append("ObjectPropertyChain");
        sbuf.append("(");
        List<IntegerObjectPropertyExpression> propertyList = this.getPropertyChain();
        propertyList.forEach(property -> {
            sbuf.append(property.toString());
            sbuf.append(" ");
        });
        sbuf.append(")");
        sbuf.append(" ");
        sbuf.append(this.getSuperProperty());
        sbuf.append(")");
        return sbuf.toString();
    }
}

