/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.datatype;

import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpressionVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntegerDataSomeValuesFrom
implements IntegerClassExpression {
    private final IntegerClassExpression filler;
    private final int hashCode;
    private final boolean normalized;
    private final int property;

    protected IntegerDataSomeValuesFrom(int propertyId, IntegerClassExpression classExpression) {
        Objects.requireNonNull(classExpression);
        this.property = propertyId;
        this.filler = classExpression;
        this.normalized = classExpression.isLiteral();
        this.hashCode = propertyId + 31 * classExpression.hashCode();
    }

    @Override
    public <T> T accept(IntegerClassExpressionVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    @Override
    public boolean containsBottom() {
        return this.filler.containsBottom();
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof IntegerDataSomeValuesFrom) {
            IntegerDataSomeValuesFrom other = (IntegerDataSomeValuesFrom)o;
            ret = this.getProperty() == other.getProperty() && this.getFiller().equals(other.getFiller());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this.getFiller().getClassesInSignature());
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this.getFiller().getDataPropertiesInSignature());
        ret.add(this.getProperty());
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    public IntegerClassExpression getFiller() {
        return this.filler;
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this.getFiller().getObjectPropertiesInSignature());
        return Collections.unmodifiableSet(ret);
    }

    public int getProperty() {
        return this.property;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean hasOnlyClasses() {
        return this.normalized;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("DataSomeValuesFrom");
        sbuf.append("(");
        sbuf.append(this.getProperty());
        sbuf.append(" ");
        sbuf.append(this.getFiller().toString());
        sbuf.append(")");
        return sbuf.toString();
    }
}

