/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.datatype;

import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpressionVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class IntegerObjectIntersectionOf
implements IntegerClassExpression {
    private final int hashCode;
    private final boolean normalized;
    private final Set<IntegerClassExpression> operands;
    private final boolean withBottom;

    protected IntegerObjectIntersectionOf(Set<IntegerClassExpression> operands) {
        Objects.requireNonNull(operands);
        this.operands = operands;
        this.hashCode = operands.hashCode();
        boolean normalized = true;
        boolean withBottom = false;
        for (IntegerClassExpression elem : this.operands) {
            if (elem.containsBottom()) {
                withBottom = true;
            }
            if (elem.isLiteral()) continue;
            normalized = false;
        }
        this.normalized = normalized;
        this.withBottom = withBottom;
    }

    @Override
    public <T> T accept(IntegerClassExpressionVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    @Override
    public boolean containsBottom() {
        return this.withBottom;
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof IntegerObjectIntersectionOf) {
            IntegerObjectIntersectionOf other = (IntegerObjectIntersectionOf)o;
            ret = this.getOperands().equals(other.getOperands()) && this.containsBottom() == other.containsBottom();
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        HashSet ret = new HashSet();
        this.getOperands().forEach(expression -> ret.addAll(expression.getClassesInSignature()));
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        HashSet ret = new HashSet();
        this.getOperands().forEach(expression -> ret.addAll(expression.getObjectPropertiesInSignature()));
        return Collections.unmodifiableSet(ret);
    }

    public Set<IntegerClassExpression> getOperands() {
        return Collections.unmodifiableSet(this.operands);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean hasOnlyClasses() {
        return this.normalized;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("ObjectIntersectionOf");
        sbuf.append("(");
        Iterator<IntegerClassExpression> it = this.getOperands().iterator();
        while (it.hasNext()) {
            IntegerClassExpression classExpression = it.next();
            sbuf.append(classExpression.toString());
            if (!it.hasNext()) continue;
            sbuf.append(" ");
        }
        sbuf.append(")");
        return sbuf.toString();
    }
}

