/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityType;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerPropertyRangeAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import de.tudresden.inf.lat.jcel.ontology.normalization.ObjectPropertyIdFinder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NormalizerNR1_2
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerNR1_2(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (axiom instanceof IntegerPropertyRangeAxiom) {
            ret = this.applyRule((IntegerPropertyRangeAxiom)axiom);
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(IntegerPropertyRangeAxiom rangeAxiom) {
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (!rangeAxiom.getRange().isLiteral()) {
            ret = new HashSet<IntegerAxiom>();
            Integer newClassId = this.getOntologyObjectFactory().getEntityManager().createAnonymousEntity(IntegerEntityType.CLASS, true);
            ret.add(this.getOntologyObjectFactory().getNormalizedAxiomFactory().createRangeAxiom(this.getObjectPropertyId(rangeAxiom.getProperty()), newClassId, rangeAxiom.getAnnotations()));
            ret.add(this.getOntologyObjectFactory().getComplexAxiomFactory().createSubClassOfAxiom(this.getOntologyObjectFactory().getDataTypeFactory().createClass(newClassId), rangeAxiom.getRange(), rangeAxiom.getAnnotations()));
        }
        return ret;
    }

    private Integer getObjectPropertyId(IntegerObjectPropertyExpression propExpr) {
        return propExpr.accept(new ObjectPropertyIdFinder(this.getOntologyObjectFactory().getEntityManager()));
    }

    private IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }
}

