/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectOneOf;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NormalizerNR4_1
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerNR4_1(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (axiom instanceof IntegerSubClassOfAxiom) {
            ret = this.applyRule((IntegerSubClassOfAxiom)axiom);
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(IntegerSubClassOfAxiom classAxiom) {
        Set<IntegerAxiom> ret = Collections.emptySet();
        IntegerClassExpression subClass = classAxiom.getSubClass();
        IntegerClassExpression superClass = classAxiom.getSuperClass();
        if (subClass.isLiteral() && superClass instanceof IntegerObjectOneOf) {
            IntegerObjectOneOf oneOf = (IntegerObjectOneOf)superClass;
            ret = new HashSet<IntegerAxiom>();
            Integer individual = oneOf.getIndividual();
            Integer auxiliaryClass = this.getOntologyObjectFactory().getEntityManager().createOrGetClassIdForIndividual(individual);
            ret.add(this.getOntologyObjectFactory().getNormalizedAxiomFactory().createNominalAxiom(auxiliaryClass, individual, classAxiom.getAnnotations()));
            ret.add(this.getOntologyObjectFactory().getNormalizedAxiomFactory().createGCI0Axiom(((IntegerClass)subClass).getId(), auxiliaryClass, classAxiom.getAnnotations()));
        }
        return ret;
    }

    private IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }
}

