/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.CompositionClosure;
import org.semanticweb.elk.reasoner.saturation.properties.SubPropertyExplorer;
import org.semanticweb.elk.reasoner.saturation.properties.SuperPropertyExplorer;

class ReducingCompositionClosure
extends CompositionClosure {
    private static final Logger LOGGER_ = Logger.getLogger(SubPropertyExplorer.class);
    final Set<IndexedPropertyChain> toRemove = new HashSet<IndexedPropertyChain>();

    ReducingCompositionClosure(IndexedBinaryPropertyChain root) {
        super(root);
        Iterator compositionIterator = this.relevantCompositions.iterator();
        while (compositionIterator.hasNext()) {
            IndexedPropertyChain next = (IndexedPropertyChain)compositionIterator.next();
            if (this.toRemove.contains(next)) {
                compositionIterator.remove();
                continue;
            }
            Set<IndexedPropertyChain> candidateSupers = SuperPropertyExplorer.getRelevantSuperProperties(next);
            candidateSupers.remove(next);
            this.toRemove.addAll(candidateSupers);
        }
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("To remove: " + this.toRemove);
            LOGGER_.trace("Reduced composition closure: " + this.relevantCompositions);
        }
    }

    @Override
    public void applyTo(Collection<IndexedPropertyChain> currentCompositions) {
        for (IndexedPropertyChain relevant : this.relevantCompositions) {
            Set<IndexedPropertyChain> subProperties = SubPropertyExplorer.getSetRelevantSubProperties(relevant);
            boolean addThis = true;
            for (IndexedPropertyChain current : currentCompositions) {
                if (!subProperties.contains(current)) continue;
                addThis = false;
                break;
            }
            if (!addThis) continue;
            currentCompositions.add(relevant);
        }
        currentCompositions.removeAll(this.toRemove);
    }
}

