/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomy;

public class ClassTaxonomyState {
    private UpdateableTaxonomy<ElkClass> taxonomy_ = null;
    final Set<ElkClass> classesForModifiedNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    final List<IndexedClass> removedClasses = new LinkedList<IndexedClass>();

    public UpdateableTaxonomy<ElkClass> getTaxonomy() {
        return this.taxonomy_;
    }

    public Writer getWriter() {
        return new Writer();
    }

    public class Writer {
        void setTaxonomy(UpdateableTaxonomy<ElkClass> classTaxonomy) {
            ClassTaxonomyState.this.taxonomy_ = classTaxonomy;
        }

        public void clearTaxonomy() {
            ClassTaxonomyState.this.taxonomy_ = null;
        }

        public void markClassForModifiedNode(ElkClass elkClass) {
            ClassTaxonomyState.this.classesForModifiedNodes.add(elkClass);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markClassesForModifiedNode(Node<ElkClass> node) {
            Node<ElkClass> node2 = node;
            synchronized (node2) {
                for (ElkClass clazz : node.getMembers()) {
                    this.markClassForModifiedNode(clazz);
                }
            }
        }

        public void markRemovedClass(IndexedClass clazz) {
            ClassTaxonomyState.this.removedClasses.add(clazz);
        }

        public void clearModifiedNodeObjects() {
            ClassTaxonomyState.this.classesForModifiedNodes.clear();
        }

        public void clearRemovedClasses() {
            ClassTaxonomyState.this.removedClasses.clear();
        }

        public void clear() {
            this.clearTaxonomy();
            this.clearModifiedNodeObjects();
            this.clearRemovedClasses();
        }
    }
}

