/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.logging;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.semanticweb.elk.util.logging.ElkMessage;
import org.semanticweb.elk.util.logging.WrappingLabel;

public class MessageDialogAppender
extends AppenderSkeleton
implements Runnable {
    protected final ConcurrentLinkedQueue<LoggingEvent> eventBuffer = new ConcurrentLinkedQueue();
    protected final AtomicReference<String> messengerThreadName = new AtomicReference<String>("");
    protected final Set<String> ignoredMessageTypes = new HashSet<String>();

    public MessageDialogAppender() {
        this.initConfiguration();
    }

    protected void initConfiguration() {
        this.threshold = Level.WARN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ConcurrentLinkedQueue<LoggingEvent> concurrentLinkedQueue = this.eventBuffer;
        synchronized (concurrentLinkedQueue) {
            this.eventBuffer.clear();
        }
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }

    @Override
    protected void append(LoggingEvent event) {
        if (!Thread.currentThread().getName().equals(this.messengerThreadName.get())) {
            this.eventBuffer.add(event);
        }
        this.ensureMessengerRuns();
    }

    protected void ensureMessengerRuns() {
        if (this.messengerThreadName.compareAndSet("", "Initialising thread ...")) {
            Thread messengerThread = new Thread(this);
            this.messengerThreadName.set(messengerThread.getName());
            messengerThread.start();
        }
    }

    protected String getCheckboxMessage(LoggingEvent event) {
        return "Do not show further messages of this kind";
    }

    protected boolean showMessage(LoggingEvent event) {
        String messageType;
        int messageLevel;
        String messageTitle;
        if (event.getLevel().isGreaterOrEqual(Level.ERROR)) {
            messageTitle = "ELK Error";
            messageLevel = 0;
        } else if (event.getLevel().isGreaterOrEqual(Level.WARN)) {
            messageTitle = "ELK Warning";
            messageLevel = 2;
        } else {
            messageTitle = "ELK Information";
            messageLevel = 1;
        }
        Object message = event.getMessage();
        if (message instanceof ElkMessage) {
            messageType = ((ElkMessage)message).getMessageType();
            if (this.ignoredMessageTypes.contains(messageType)) {
                return false;
            }
        } else {
            messageType = null;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        String messageText = event.getRenderedMessage();
        if (messageText.length() > 520) {
            messageText = messageText.substring(0, 500) + "...";
        }
        WrappingLabel label = new WrappingLabel(messageText, 600);
        label.setAlignmentX(0.0f);
        panel.add(label);
        JCheckBox ignoreMessageButton = new JCheckBox(String.format(this.getCheckboxMessage(event), 450));
        if (messageType != null) {
            ignoreMessageButton.setAlignmentX(0.0f);
            panel.add(Box.createRigidArea(new Dimension(0, 10)));
            panel.add(ignoreMessageButton);
        }
        JOptionPane.showMessageDialog(null, panel, messageTitle, messageLevel);
        if (ignoreMessageButton.isSelected()) {
            this.ignoredMessageTypes.add(messageType);
        }
        return true;
    }

    @Override
    public void run() {
        while (!this.eventBuffer.isEmpty()) {
            this.showMessage(this.eventBuffer.poll());
        }
        this.messengerThreadName.set("");
        if (!this.eventBuffer.isEmpty()) {
            this.ensureMessengerRuns();
        }
    }
}

