/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import org.apache.jena.rdfconnection.RDFConnectionRemoteBuilder;

class LibRDFConn {
    private static String dftName = "default";

    LibRDFConn() {
    }

    static boolean isDefault(String name) {
        return name == null || name.equals(dftName);
    }

    private static String queryStringForGraph(String ch, String graphName) {
        return ch + (LibRDFConn.isDefault(graphName) ? "default" : "graph=" + graphName);
    }

    static String urlForGraph(String graphStoreProtocolService, String graphName) {
        String ch = "?";
        if (graphStoreProtocolService.contains("?")) {
            ch = "&";
        }
        return graphStoreProtocolService + LibRDFConn.queryStringForGraph(ch, graphName);
    }

    static String formServiceURL(String destination, String srvEndpoint) {
        if (srvEndpoint == null) {
            return null;
        }
        if (srvEndpoint == RDFConnectionRemoteBuilder.SameAsDestination) {
            return destination;
        }
        if (destination == null) {
            return srvEndpoint;
        }
        if (srvEndpoint.startsWith("http:/") || srvEndpoint.startsWith("https:/")) {
            return srvEndpoint;
        }
        String queryString = null;
        String dest = destination;
        if (destination.contains("?")) {
            int i = destination.indexOf(63);
            queryString = destination.substring(i);
            dest = destination.substring(0, i);
        }
        if (dest.endsWith("/")) {
            dest = dest.substring(0, dest.length() - 1);
        }
        dest = dest + "/" + srvEndpoint;
        if (queryString != null) {
            dest = dest + queryString;
        }
        return dest;
    }
}

