/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.rulebased;

import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.REntryImpl;
import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.SEntryImpl;
import de.tudresden.inf.lat.jcel.core.completion.common.ClassifierStatus;
import de.tudresden.inf.lat.jcel.core.completion.common.REntry;
import de.tudresden.inf.lat.jcel.core.completion.common.SEntry;
import de.tudresden.inf.lat.jcel.core.graph.IntegerRelationMapImpl;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerBidirectionalGraphImpl;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraphImpl;
import de.tudresden.inf.lat.jcel.core.graph.VNode;
import de.tudresden.inf.lat.jcel.core.graph.VNodeImpl;
import de.tudresden.inf.lat.jcel.coreontology.axiom.ExtendedOntology;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class ClassifierStatusImpl
implements ClassifierStatus {
    private static final String COMMA_SEPARATOR = ",";
    private static final int bottomClassId = IntegerEntityManager.bottomClassId;
    private static final int bottomObjectPropertyId = IntegerEntityManager.bottomObjectPropertyId;
    private static final int topClassId = IntegerEntityManager.topClassId;
    private static final int topObjectPropertyId = IntegerEntityManager.topObjectPropertyId;
    private IntegerSubsumerGraphImpl classGraph = null;
    private final Map<Integer, Set<Integer>> cognateFunctPropMap = new HashMap<Integer, Set<Integer>>();
    private final ExtendedOntology extendedOntology;
    private IntegerEntityManager entityManager = null;
    private final Map<VNodeImpl, Integer> invNodeSet = new HashMap<VNodeImpl, Integer>();
    private final Object monitorClassGraph = new Object();
    private final Object monitorRelationSet = new Object();
    private final Object monitorSetQsubR = new Object();
    private final Object monitorSetQsubS = new Object();
    private final Map<Integer, VNodeImpl> nodeSet = new HashMap<Integer, VNodeImpl>();
    private IntegerSubsumerBidirectionalGraphImpl objectPropertyGraph = null;
    private IntegerRelationMapImpl relationSet = null;
    private final Set<REntry> setQsubR = new TreeSet<REntry>();
    private final Set<SEntry> setQsubS = new TreeSet<SEntry>();

    public ClassifierStatusImpl(IntegerEntityManager generator, ExtendedOntology ontology) {
        Objects.requireNonNull(generator);
        Objects.requireNonNull(ontology);
        this.entityManager = generator;
        this.extendedOntology = ontology;
        this.createClassGraph();
        this.createObjectPropertyGraph();
        this.createRelationSet();
        this.createSetOfNodes();
        this.createMapOfObjectPropertiesWithFunctionalAncestor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addNewREntry(int propertyId, int leftClassId, int rightClassId) {
        boolean ret = false;
        Object object = this.monitorSetQsubR;
        synchronized (object) {
            ret = this.setQsubR.add(new REntryImpl(propertyId, leftClassId, rightClassId));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addNewSEntry(int subClassId, int superClassId) {
        boolean ret = false;
        Object object = this.monitorSetQsubS;
        synchronized (object) {
            ret = this.setQsubS.add(new SEntryImpl(subClassId, superClassId));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToR(int property, int leftClass, int rightClass) {
        boolean ret = false;
        Object object = this.monitorRelationSet;
        synchronized (object) {
            ret = this.relationSet.add(property, leftClass, rightClass);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToS(int subClass, int superClass) {
        boolean ret = false;
        Object object = this.monitorClassGraph;
        synchronized (object) {
            ret = this.classGraph.addAncestor(subClass, superClass);
        }
        return ret;
    }

    @Override
    public boolean contains(VNode node) {
        Objects.requireNonNull(node);
        return Objects.nonNull(this.invNodeSet.get(node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClassGraph() {
        Object object = this.monitorClassGraph;
        synchronized (object) {
            this.classGraph = new IntegerSubsumerGraphImpl(bottomClassId, topClassId);
        }
        this.nodeSet.clear();
        this.invNodeSet.clear();
        this.getExtendedOntology().getClassSet().forEach(elem -> {
            VNodeImpl node = new VNodeImpl((int)elem);
            this.nodeSet.put((Integer)elem, node);
            this.invNodeSet.put(node, (Integer)elem);
        });
    }

    private void createMapOfObjectPropertiesWithFunctionalAncestor() {
        this.extendedOntology.getFunctionalObjectProperties().forEach(s -> {
            Collection<Integer> cognates = this.getSubObjectProperties((int)s);
            cognates.forEach(r -> {
                Set<Integer> currentSet = this.cognateFunctPropMap.get(r);
                if (Objects.isNull(currentSet)) {
                    currentSet = new HashSet<Integer>();
                    this.cognateFunctPropMap.put((Integer)r, currentSet);
                }
                currentSet.addAll(cognates);
            });
        });
    }

    private void createObjectPropertyGraph() {
        this.objectPropertyGraph = new IntegerSubsumerBidirectionalGraphImpl(bottomObjectPropertyId, topObjectPropertyId);
        this.extendedOntology.getObjectPropertySet().forEach(index -> {
            this.objectPropertyGraph.addAncestor((int)index, topObjectPropertyId);
            int inverseProp = this.entityManager.createOrGetInverseObjectPropertyOf((Integer)index);
            this.objectPropertyGraph.addAncestor(inverseProp, topObjectPropertyId);
        });
        this.extendedOntology.getObjectPropertySet().forEach(property -> {
            Set<RI2Axiom> axiomSet = this.extendedOntology.getRI2rAxioms((int)property);
            axiomSet.forEach(axiom -> this.objectPropertyGraph.addAncestor(axiom.getSubProperty(), axiom.getSuperProperty()));
        });
        this.makeTransitiveClosure(this.objectPropertyGraph);
    }

    @Override
    public int createOrGetNodeId(VNode node) {
        Objects.requireNonNull(node);
        Integer ret = this.invNodeSet.get(node);
        if (Objects.isNull(ret)) {
            ret = node.getClassId();
            if (!node.isEmpty()) {
                ret = this.getIdGenerator().createAnonymousEntity(IntegerEntityType.CLASS, true);
                VNodeImpl newNode = new VNodeImpl(node.getClassId());
                newNode.addExistentialsOf(node);
                this.nodeSet.put(ret, newNode);
                this.invNodeSet.put(newNode, ret);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRelationSet() {
        Collection<Integer> collection = this.getObjectPropertyGraph().getElements();
        Object object = this.monitorRelationSet;
        synchronized (object) {
            this.relationSet = new IntegerRelationMapImpl();
            collection.forEach(index -> this.relationSet.add((int)index));
        }
    }

    private void createSetOfNodes() {
        this.getExtendedOntology().getClassSet().forEach(classId -> this.createOrGetNodeId(new VNodeImpl((int)classId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteClassGraph() {
        Object object = this.monitorClassGraph;
        synchronized (object) {
            this.classGraph = null;
        }
    }

    protected void deleteObjectPropertyGraph() {
        this.objectPropertyGraph = null;
    }

    protected IntegerSubsumerGraphImpl getClassGraph() {
        return this.classGraph;
    }

    @Override
    public Object getClassGraphMonitor() {
        return this.monitorClassGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeepSizeOfR() {
        long ret;
        Object object = this.monitorRelationSet;
        synchronized (object) {
            ret = this.relationSet.getDeepSize();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDeepSizeOfS() {
        long ret;
        Object object = this.monitorClassGraph;
        synchronized (object) {
            ret = this.classGraph.getDeepSize();
        }
        return ret;
    }

    public long getDeepSizeOfV() {
        return this.nodeSet.keySet().stream().map(nodeId -> this.nodeSet.get(nodeId).getDeepSize()).reduce(0L, (accum, elem) -> accum + elem);
    }

    @Override
    public ExtendedOntology getExtendedOntology() {
        return this.extendedOntology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getFirstBySecond(int propertyId, int classId) {
        TreeSet<Integer> ret = new TreeSet<Integer>();
        Object object = this.monitorRelationSet;
        synchronized (object) {
            ret.addAll(this.relationSet.getBySecond(propertyId, classId));
        }
        return ret;
    }

    protected IntegerEntityManager getIdGenerator() {
        return this.entityManager;
    }

    @Override
    public int getInverseObjectPropertyOf(int propertyId) {
        return this.entityManager.createOrGetInverseObjectPropertyOf(propertyId);
    }

    @Override
    public VNode getNode(int nodeId) {
        return this.nodeSet.get(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfREntries() {
        int ret = 0;
        Object object = this.monitorSetQsubR;
        synchronized (object) {
            ret = this.setQsubR.size();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfSEntries() {
        int ret = 0;
        Object object = this.monitorSetQsubS;
        synchronized (object) {
            ret = this.setQsubS.size();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getObjectPropertiesByFirst(int cA) {
        TreeSet<Integer> ret = new TreeSet<Integer>();
        Object object = this.monitorRelationSet;
        synchronized (object) {
            ret.addAll(this.relationSet.getRelationsByFirst(cA));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getObjectPropertiesBySecond(int cA) {
        TreeSet<Integer> ret = new TreeSet<Integer>();
        Object object = this.monitorRelationSet;
        synchronized (object) {
            ret.addAll(this.relationSet.getRelationsBySecond(cA));
        }
        return ret;
    }

    @Override
    public Set<Integer> getObjectPropertiesWithFunctionalAncestor(int objectProperty) {
        Set<Integer> ret = this.cognateFunctPropMap.get(objectProperty);
        ret = Objects.isNull(ret) ? Collections.emptySet() : Collections.unmodifiableSet(ret);
        return ret;
    }

    protected IntegerSubsumerBidirectionalGraphImpl getObjectPropertyGraph() {
        return this.objectPropertyGraph;
    }

    protected IntegerRelationMapImpl getRelationSet() {
        return this.relationSet;
    }

    @Override
    public Object getRelationSetMonitor() {
        return this.monitorRelationSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getSecondByFirst(int propertyId, int classId) {
        TreeSet<Integer> ret = new TreeSet<Integer>();
        Object object = this.monitorRelationSet;
        synchronized (object) {
            ret.addAll(this.relationSet.getByFirst(propertyId, classId));
        }
        return ret;
    }

    public long getSizeOfV() {
        return this.nodeSet.size();
    }

    @Override
    public Collection<Integer> getSubObjectProperties(int objectProperty) {
        return Collections.unmodifiableCollection(this.objectPropertyGraph.getSubsumees(objectProperty));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Integer> getSubsumers(int classId) {
        Collection<Integer> ret = null;
        Object object = this.monitorClassGraph;
        synchronized (object) {
            ret = this.classGraph.getSubsumers(classId);
        }
        return ret;
    }

    @Override
    public Collection<Integer> getSuperObjectProperties(int objectProperty) {
        return Collections.unmodifiableCollection(this.objectPropertyGraph.getSubsumers(objectProperty));
    }

    private void makeTransitiveClosure(IntegerSubsumerBidirectionalGraphImpl graph) {
        boolean hasChanged = true;
        while (hasChanged) {
            hasChanged = false;
            for (int elem : graph.getElements()) {
                Collection<Integer> subsumerSet = graph.getSubsumers(elem);
                HashSet<Integer> allSubsumers = new HashSet<Integer>();
                allSubsumers.add(elem);
                subsumerSet.forEach(otherElem -> allSubsumers.addAll(graph.getSubsumers((int)otherElem)));
                allSubsumers.removeAll(subsumerSet);
                if (allSubsumers.isEmpty()) continue;
                hasChanged = true;
                allSubsumers.forEach(subsumer -> graph.addAncestor(elem, (int)subsumer));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REntry removeNextREntry() {
        REntry ret = null;
        Object object = this.monitorSetQsubR;
        synchronized (object) {
            if (this.setQsubR.isEmpty()) {
                throw new NoSuchElementException();
            }
            ret = this.setQsubR.iterator().next();
            this.setQsubR.remove(ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SEntry removeNextSEntry() {
        SEntry ret = null;
        Object object = this.monitorSetQsubS;
        synchronized (object) {
            if (this.setQsubS.isEmpty()) {
                throw new NoSuchElementException();
            }
            ret = this.setQsubS.iterator().next();
            this.setQsubS.remove(ret);
        }
        return ret;
    }

    public void outputSetS(Writer output) throws IOException {
        BufferedWriter writer = new BufferedWriter(output);
        Collection<Integer> concepts = this.classGraph.getElements();
        for (Integer concept : concepts) {
            Collection<Integer> subsumers = this.classGraph.getSubsumers(concept);
            for (Integer subsumer : subsumers) {
                writer.write(this.entityManager.getName(concept));
                writer.write(COMMA_SEPARATOR);
                writer.write(this.entityManager.getName(subsumer));
                writer.newLine();
            }
        }
        writer.flush();
    }

    public void outputSetR(Writer output) throws IOException {
        BufferedWriter writer = new BufferedWriter(output);
        Collection<Integer> concepts = this.classGraph.getElements();
        for (Integer concept : concepts) {
            Collection<Integer> relations = this.relationSet.getRelationsByFirst(concept);
            for (Integer relation : relations) {
                Collection<Integer> otherConcepts = this.relationSet.getByFirst(relation, concept);
                for (Integer otherConcept : otherConcepts) {
                    writer.write(this.entityManager.getName(concept));
                    writer.write(COMMA_SEPARATOR);
                    writer.write(this.entityManager.getName(relation));
                    writer.write(COMMA_SEPARATOR);
                    writer.write(this.entityManager.getName(otherConcept));
                    writer.newLine();
                }
            }
        }
        writer.flush();
    }
}

