/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.rulebased;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class TurtleRenderer {
    private static final String colonSlashSlash = "://";
    private static final String fragmentSeparator = "#";
    private static final String lineEnd = ".";
    private static final String prefixBeginning = "p";
    private static final String prefixKeyword = "@prefix";
    private static final String prefixSeparator = ":";
    private static final String separator = "\t";
    private static final String slash = "/";
    private static final String space = " ";
    private static final String uriDelimiterLeft = "<";
    private static final String uriDelimiterRight = ">";
    private final Map<String, String> mapOfPrefixes = new TreeMap<String, String>();
    private final BufferedWriter output;

    public TurtleRenderer(Writer writer) {
        Objects.requireNonNull(writer);
        this.output = new BufferedWriter(writer);
    }

    private String getName(URI uri) {
        String path;
        String ret = uri.getFragment();
        if (Objects.isNull(ret) && Objects.nonNull(path = uri.getPath())) {
            ret = path.substring(path.lastIndexOf(slash) + slash.length());
        }
        return ret;
    }

    private String getPrefix(URI uri) {
        String ret = "";
        if (Objects.nonNull(uri.getHost())) {
            ret = uri.getScheme() + colonSlashSlash + uri.getHost();
            if (Objects.isNull(uri.getFragment())) {
                String path = uri.getPath();
                if (Objects.nonNull(path)) {
                    ret = ret + path.substring(0, path.lastIndexOf(slash) + slash.length());
                }
            } else {
                ret = ret + uri.getPath() + fragmentSeparator;
            }
        }
        return ret;
    }

    private String getTurtleEntity(String name) {
        String ret = prefixSeparator + name;
        try {
            URI uri = new URI(name);
            String prefix = this.getPrefix(uri);
            if (prefix.length() > 0) {
                String prefixId = this.mapOfPrefixes.get(prefix);
                ret = Objects.nonNull(prefixId) ? prefixId + prefixSeparator + this.getName(uri) : uriDelimiterLeft + name + uriDelimiterRight;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return ret;
    }

    public boolean loadPrefixes(Collection<String> identifiers) {
        boolean ret = false;
        for (String name : identifiers) {
            try {
                URI uri = new URI(name);
                String prefix = this.getPrefix(uri);
                if (prefix.length() <= 0 || this.mapOfPrefixes.containsKey(prefix)) continue;
                this.mapOfPrefixes.put(prefix, prefixBeginning + this.mapOfPrefixes.keySet().size());
                ret = true;
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return ret;
    }

    public void renderPrefixes() throws IOException {
        for (String prefix : this.mapOfPrefixes.keySet()) {
            String prefixId = this.mapOfPrefixes.get(prefix);
            this.output.write(prefixKeyword);
            this.output.write(space);
            this.output.write(prefixId);
            this.output.write(prefixSeparator);
            this.output.write(space);
            this.output.write(uriDelimiterLeft);
            this.output.write(prefix);
            this.output.write(uriDelimiterRight);
            this.output.write(space);
            this.output.write(lineEnd);
            this.output.newLine();
        }
        this.output.newLine();
        this.output.flush();
    }

    public void renderTriple(String predicate, String subject, String object) throws IOException {
        this.output.write(this.getTurtleEntity(subject));
        this.output.write(separator);
        this.output.write(this.getTurtleEntity(predicate));
        this.output.write(separator);
        this.output.write(this.getTurtleEntity(object));
        this.output.write(space);
        this.output.write(lineEnd);
        this.output.newLine();
        this.output.flush();
    }
}

