/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.IntStream;

public class ArraySetIterator
implements Iterator<Integer> {
    private final int[] array;
    private int pointer = 0;
    private final int size;

    public ArraySetIterator(int[] a, int s) {
        Objects.requireNonNull(a);
        this.array = a;
        this.size = s;
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof ArraySetIterator) {
            ArraySetIterator other = (ArraySetIterator)o;
            ret = this.size == other.size && this.pointer == other.pointer;
            ret = ret && IntStream.range(0, this.size).allMatch(index -> this.array[index] == other.array[index]);
        }
        return ret;
    }

    public int hashCode() {
        return this.pointer + 31 * this.array.hashCode();
    }

    @Override
    public boolean hasNext() {
        return this.pointer < this.size;
    }

    @Override
    public Integer next() {
        if (this.pointer >= this.size) {
            throw new NoSuchElementException();
        }
        return this.array[this.pointer++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

