/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import de.tudresden.inf.lat.jcel.core.graph.HashArraySetIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;

public class HashArraySet
implements Set<Integer> {
    protected static final int EMPTY = Integer.MIN_VALUE;
    private static final int exponentialGrowthFactor = 2;
    private static final int initialSize = 16;
    private static final int linearGrowthFactor = 1;
    private static final int REHASH = Integer.MIN_VALUE;
    private int[] array = null;
    private int size = 0;

    public HashArraySet() {
        this.clear();
    }

    @Override
    public synchronized boolean add(Integer elem) {
        Objects.requireNonNull(elem);
        boolean ret = false;
        int pointer = this.find(elem, this.array);
        if (pointer == Integer.MIN_VALUE || pointer < 0) {
            ret = true;
            if (pointer != Integer.MIN_VALUE) {
                pointer = -1 * (pointer + 1);
                this.array[pointer] = elem;
            } else {
                this.array = this.rehashAndAdd(this.array, elem);
            }
            ++this.size;
        }
        return ret;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends Integer> collection) {
        Objects.requireNonNull(collection);
        boolean ret = false;
        for (Integer n : collection) {
            ret |= this.add(n);
        }
        return ret;
    }

    @Override
    public synchronized void clear() {
        this.array = this.makeNewArray(16);
        this.size = 0;
    }

    private int computeNewLength(int length) {
        int ret = 1 + 2 * length;
        while (ret % 2 == 0 || ret % 3 == 0 || ret % 5 == 0) {
            ++ret;
        }
        return ret;
    }

    @Override
    public synchronized boolean contains(Object elem) {
        Objects.requireNonNull(elem);
        boolean ret = false;
        int e = (Integer)elem;
        int pointer = this.find(e, this.array);
        ret = pointer >= 0 && pointer != Integer.MIN_VALUE;
        return ret;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        return collection.stream().allMatch(elem -> this.contains(elem));
    }

    @Override
    public synchronized boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof HashArraySet) {
            HashArraySet other = (HashArraySet)o;
            ret = this.size == other.size;
            ret = ret && IntStream.range(0, this.array.length).map(index -> this.array[index]).filter(current -> current != Integer.MIN_VALUE).allMatch(current -> other.contains(current));
            ret = ret && IntStream.range(0, other.array.length).map(index -> other.array[index]).filter(current -> current != Integer.MIN_VALUE).allMatch(current -> this.contains(current));
        }
        return ret;
    }

    private int find(int elem, int[] currentArray) {
        if (elem == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Out of range: " + elem);
        }
        if (elem == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Out of range: " + elem);
        }
        boolean indexFound = false;
        int pointer = Integer.MIN_VALUE;
        int mod = currentArray.length;
        int dist = 1;
        int initial = elem;
        while (!indexFound && dist < mod) {
            pointer = Math.abs(initial + dist) % mod;
            int element = currentArray[pointer];
            if (element == Integer.MIN_VALUE) {
                pointer = -1 * (pointer + 1);
                indexFound = true;
                continue;
            }
            if (elem == element) {
                indexFound = true;
                continue;
            }
            dist *= 2;
        }
        if (!indexFound) {
            pointer = Integer.MIN_VALUE;
        }
        return pointer;
    }

    @Override
    public synchronized int hashCode() {
        return this.array.hashCode();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized Iterator<Integer> iterator() {
        return new HashArraySetIterator(this.array, this.size);
    }

    private int[] makeNewArray(int size) {
        int[] ret = new int[size];
        IntStream.range(0, size).forEach((int i) -> {
            ret[i] = Integer.MIN_VALUE;
        });
        return ret;
    }

    private boolean rehash(int[] originalArray, int[] newArray) {
        boolean ret = true;
        for (int index = 0; ret && index < originalArray.length; ++index) {
            int element = originalArray[index];
            if (element == Integer.MIN_VALUE) continue;
            int pointer = this.find(element, newArray);
            if (pointer == Integer.MIN_VALUE) {
                ret = false;
                continue;
            }
            if (pointer >= 0) continue;
            pointer = -1 * (pointer + 1);
            newArray[pointer] = element;
        }
        return ret;
    }

    private int[] rehashAndAdd(int[] originalArray, int elem) {
        int[] newArray = originalArray;
        boolean rehashDone = false;
        while (!rehashDone) {
            int newLength = this.computeNewLength(newArray.length);
            newArray = this.makeNewArray(newLength);
            int newPointer = this.find(elem, newArray);
            newPointer = -1 * (newPointer + 1);
            newArray[newPointer] = elem;
            rehashDone = this.rehash(originalArray, newArray);
        }
        return newArray;
    }

    @Override
    public synchronized boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.toArrayList().toArray(a);
    }

    private synchronized ArrayList<Integer> toArrayList() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        IntStream.range(0, this.array.length).forEach((int index) -> {
            int element = this.array[index];
            if (element != Integer.MIN_VALUE) {
                ret.add(element);
            }
        });
        return ret;
    }

    public synchronized String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[ ");
        IntStream.range(0, this.array.length).forEach((int index) -> {
            int element = this.array[index];
            if (element == Integer.MIN_VALUE) {
                sbuf.append(".");
            } else {
                sbuf.append(element);
            }
            sbuf.append(" ");
        });
        sbuf.append("]");
        return sbuf.toString();
    }
}

