/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.saturation;

import de.tudresden.inf.lat.jcel.core.saturation.SaturationRule;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomFactory;
import de.tudresden.inf.lat.jcel.coreontology.axiom.RI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SR3Rule
implements SaturationRule {
    private final NormalizedIntegerAxiomFactory factory;
    private final IntegerEntityManager idGenerator;

    public SR3Rule(NormalizedIntegerAxiomFactory factory, IntegerEntityManager entityManager) {
        Objects.requireNonNull(factory);
        Objects.requireNonNull(entityManager);
        this.factory = factory;
        this.idGenerator = entityManager;
    }

    @Override
    public Set<NormalizedIntegerAxiom> apply(Set<NormalizedIntegerAxiom> originalSet) {
        Objects.requireNonNull(originalSet);
        HashSet<NormalizedIntegerAxiom> ret = new HashSet<NormalizedIntegerAxiom>();
        ret.addAll(originalSet);
        originalSet.forEach(normalizedAxiom -> {
            if (normalizedAxiom instanceof RI3Axiom) {
                RI3Axiom axiom = (RI3Axiom)normalizedAxiom;
                Integer invLeftSubProp = this.idGenerator.createOrGetInverseObjectPropertyOf(axiom.getLeftSubProperty());
                Integer invRightSubProp = this.idGenerator.createOrGetInverseObjectPropertyOf(axiom.getRightSubProperty());
                Integer invSuperProp = this.idGenerator.createOrGetInverseObjectPropertyOf(axiom.getSuperProperty());
                RI3Axiom newAxiom = this.factory.createRI3Axiom(invRightSubProp, invLeftSubProp, invSuperProp, axiom.getAnnotations());
                ret.add(newAxiom);
            }
        });
        return Collections.unmodifiableSet(ret);
    }
}

