/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.OWLRendererIOException;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class AbstractRenderer {
    private ShortFormProvider shortFormProvider;
    private int lastNewLinePos = -1;
    private int currentPos;
    private final Writer writer;
    private final List<Integer> tabs = new ArrayList<Integer>();
    private boolean useTabbing = true;
    private boolean useWrapping = true;

    protected AbstractRenderer(Writer writer, ShortFormProvider shortFormProvider) {
        this.writer = writer;
        this.shortFormProvider = shortFormProvider;
        this.pushTab(0);
    }

    protected void setUseTabbing(boolean useTabbing) {
        this.useTabbing = useTabbing;
    }

    protected void setUseWrapping(boolean useWrapping) {
        this.useWrapping = useWrapping;
    }

    protected boolean isUseWrapping() {
        return this.useWrapping;
    }

    protected boolean isUseTabbing() {
        return this.useTabbing;
    }

    protected void flush() throws OWLRendererException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new OWLRendererIOException(e);
        }
    }

    protected void pushTab(int size) {
        this.tabs.add(0, size);
    }

    protected void incrementTab(int increment) {
        int base = 0;
        if (!this.tabs.isEmpty()) {
            base = this.tabs.get(0);
        }
        this.tabs.add(0, base + increment);
    }

    protected void popTab() {
        this.tabs.remove(0);
    }

    protected void writeTab() {
        int tab = this.tabs.get(0);
        for (int i = 0; i < tab; ++i) {
            this.write(" ");
        }
    }

    protected int getIndent() {
        return this.currentPos - this.lastNewLinePos - 2;
    }

    protected void write(@Nullable String s) {
        if (s == null) {
            return;
        }
        int indexOfNewLine = s.indexOf(10);
        if (indexOfNewLine != -1) {
            this.lastNewLinePos = this.currentPos + indexOfNewLine;
        }
        this.currentPos += s.length();
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    protected void write(char ch) {
        this.write(Character.toString(ch));
    }

    protected void writeSpace() {
        this.write(" ");
    }

    protected void write(@Nonnull ManchesterOWLSyntax keyword) {
        this.write(" ", keyword, " ");
    }

    protected void writeFrameKeyword(@Nonnull ManchesterOWLSyntax keyword) {
        this.write("", keyword, ": ");
    }

    protected void writeSectionKeyword(@Nonnull ManchesterOWLSyntax keyword) {
        this.write(" ", keyword, ": ");
    }

    protected void writeNewLine() {
        this.write("\n");
        if (this.useTabbing) {
            this.writeTab();
        }
    }

    protected void write(String prefix, @Nonnull ManchesterOWLSyntax keyword, String suffix) {
        this.write(prefix);
        this.write(keyword.toString());
        this.write(suffix);
    }

    protected ShortFormProvider getShortFormProvider() {
        return this.shortFormProvider;
    }

    protected void setShortFormProvider(ShortFormProvider p) {
        this.shortFormProvider = p;
    }
}

