/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.rdf.rdfxml.parser.AbstractState;
import org.semanticweb.owlapi.rdf.rdfxml.parser.NodeElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ParseTypeCollectionElement
extends AbstractState
implements State {
    protected final NodeElement nodeElement;
    protected String pIRI;
    @Nullable
    protected String reificationID;
    protected String lastCellIRI;

    @Nonnull
    protected String lastCell() {
        return (String)OWLAPIPreconditions.verifyNotNull((Object)this.lastCellIRI);
    }

    @Nonnull
    protected String propertyIRI() {
        return (String)OWLAPIPreconditions.verifyNotNull((Object)this.pIRI);
    }

    ParseTypeCollectionElement(NodeElement nodeElement, @Nonnull RDFParser parser) {
        super(parser);
        this.nodeElement = nodeElement;
    }

    @Override
    public void startElement(String namespaceIRI, String localName, String qName, @Nonnull Attributes atts) throws SAXException {
        if (this.pIRI == null) {
            this.pIRI = this.nodeElement.getPropertyIRI(namespaceIRI + localName);
            this.reificationID = this.nodeElement.getReificationID(atts);
        } else {
            NodeElement collectionNode = new NodeElement(this.parser);
            this.parser.pushState(collectionNode);
            this.parser.state.startElement(namespaceIRI, localName, qName, atts);
            String newListCellIRI = this.listCell(collectionNode.subjectIRI());
            if (this.lastCellIRI == null) {
                this.parser.statementWithResourceValue(this.nodeElement.subjectIRI(), this.propertyIRI(), newListCellIRI, this.reificationID);
            } else {
                this.parser.statementWithResourceValue(this.lastCell(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", newListCellIRI, null);
            }
            this.lastCellIRI = newListCellIRI;
        }
    }

    @Nonnull
    String listCell(@Nonnull String valueIRI) {
        String listCellIRI = NodeID.nextAnonymousIRI();
        this.parser.statementWithResourceValue(listCellIRI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", valueIRI, null);
        this.parser.statementWithResourceValue(listCellIRI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#List", null);
        return listCellIRI;
    }

    @Override
    public void endElement(String namespaceIRI, String localName, String qName) {
        if (this.lastCellIRI == null) {
            this.parser.statementWithResourceValue(this.nodeElement.subjectIRI(), this.propertyIRI(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil", this.reificationID);
        } else {
            this.parser.statementWithResourceValue(this.lastCell(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil", null);
        }
        this.parser.popState();
    }

    @Override
    public void characters(char[] data, int start, int length) {
        this.parser.verify(this.notBlank(data, start, length), "Expecting an object element instead of character content.");
    }
}

