/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.entries.IndexedEntryConverter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexObjectConverter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDataHasValue;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDisjointnessAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectComplementOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedSubClassOfAxiom;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedObjectFilter;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedObjectVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.util.collections.entryset.KeyEntry;
import org.semanticweb.elk.util.collections.entryset.KeyEntryFactory;
import org.semanticweb.elk.util.collections.entryset.KeyEntryHashSet;

public class IndexedObjectCache
implements IndexedObjectFilter {
    private static final Logger LOGGER_ = Logger.getLogger(IndexedObjectCache.class);
    protected final KeyEntryHashSet<IndexedClassExpression> indexedClassExpressionLookup;
    protected final KeyEntryHashSet<IndexedPropertyChain> indexedPropertyChainLookup;
    protected final KeyEntryHashSet<IndexedAxiom> indexedAxiomLookup;
    protected int indexedClassCount = 0;
    protected int indexedIndividualCount = 0;
    protected int indexedObjectPropertyCount = 0;
    final IndexedObjectVisitor<Boolean> inserter = new IndexedObjectVisitor<Boolean>(){

        @Override
        public Boolean visit(IndexedClass element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + element));
            }
            if (IndexedObjectCache.this.indexedClassExpressionLookup.add(element)) {
                ++IndexedObjectCache.this.indexedClassCount;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(IndexedIndividual element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + element));
            }
            if (IndexedObjectCache.this.indexedClassExpressionLookup.add(element)) {
                ++IndexedObjectCache.this.indexedIndividualCount;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(IndexedObjectComplementOf element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.add(element);
        }

        @Override
        public Boolean visit(IndexedObjectIntersectionOf element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.add(element);
        }

        @Override
        public Boolean visit(IndexedObjectSomeValuesFrom element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.add(element);
        }

        @Override
        public Boolean visit(IndexedObjectUnionOf element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.add(element);
        }

        @Override
        public Boolean visit(IndexedDataHasValue element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.add(element);
        }

        @Override
        public Boolean visit(IndexedObjectProperty element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + element));
            }
            if (IndexedObjectCache.this.indexedPropertyChainLookup.add(element)) {
                ++IndexedObjectCache.this.indexedObjectPropertyCount;
                if (SaturatedPropertyChain.isRelevant(element)) {
                    SaturatedPropertyChain.getCreate(element);
                }
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(IndexedBinaryPropertyChain element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + element));
            }
            if (IndexedObjectCache.this.indexedPropertyChainLookup.add(element)) {
                if (SaturatedPropertyChain.isRelevant(element)) {
                    SaturatedPropertyChain.getCreate(element);
                }
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(IndexedSubClassOfAxiom axiom) {
            return true;
        }

        @Override
        public Boolean visit(IndexedDisjointnessAxiom axiom) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Adding " + axiom));
            }
            return IndexedObjectCache.this.indexedAxiomLookup.add(axiom);
        }
    };
    final IndexedObjectVisitor<Boolean> deletor = new IndexedObjectVisitor<Boolean>(){

        @Override
        public Boolean visit(IndexedClass element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + element));
            }
            if (IndexedObjectCache.this.indexedClassExpressionLookup.removeEntry(element) != null) {
                --IndexedObjectCache.this.indexedClassCount;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(IndexedIndividual element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + element));
            }
            if (IndexedObjectCache.this.indexedClassExpressionLookup.removeEntry(element) != null) {
                --IndexedObjectCache.this.indexedIndividualCount;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(IndexedObjectComplementOf element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.removeEntry(element) != null;
        }

        @Override
        public Boolean visit(IndexedObjectIntersectionOf element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.removeEntry(element) != null;
        }

        @Override
        public Boolean visit(IndexedObjectSomeValuesFrom element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.removeEntry(element) != null;
        }

        @Override
        public Boolean visit(IndexedObjectUnionOf element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.removeEntry(element) != null;
        }

        @Override
        public Boolean visit(IndexedDataHasValue element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + element));
            }
            return IndexedObjectCache.this.indexedClassExpressionLookup.removeEntry(element) != null;
        }

        @Override
        public Boolean visit(IndexedObjectProperty element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + element));
            }
            if (IndexedObjectCache.this.indexedPropertyChainLookup.removeEntry(element) != null) {
                --IndexedObjectCache.this.indexedObjectPropertyCount;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(IndexedBinaryPropertyChain element) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + element));
            }
            return IndexedObjectCache.this.indexedPropertyChainLookup.removeEntry(element) != null;
        }

        @Override
        public Boolean visit(IndexedSubClassOfAxiom axiom) {
            return true;
        }

        @Override
        public Boolean visit(IndexedDisjointnessAxiom axiom) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Removing " + axiom));
            }
            return IndexedObjectCache.this.indexedAxiomLookup.removeEntry(axiom) != null;
        }
    };

    public IndexedObjectCache() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"Creating new cache");
        }
        this.indexedClassExpressionLookup = new KeyEntryHashSet<IndexedClassExpression>(new IndexedClassExpressionViewFactory(), 1024);
        this.indexedPropertyChainLookup = new KeyEntryHashSet<IndexedPropertyChain>(new IndexedPropertyChainViewFactory(), 128);
        this.indexedAxiomLookup = new KeyEntryHashSet<IndexedAxiom>(new IndexedAxiomViewFactory(), 1024);
    }

    public IndexObjectConverter getIndexObjectConverter() {
        return new IndexObjectConverter(this, this);
    }

    public void clear() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"Clear cache");
        }
        this.indexedClassExpressionLookup.clear();
        this.indexedPropertyChainLookup.clear();
        this.indexedAxiomLookup.clear();
        this.indexedClassCount = 0;
        this.indexedIndividualCount = 0;
        this.indexedObjectPropertyCount = 0;
    }

    public long size() {
        return this.indexedClassCount + this.indexedIndividualCount + this.indexedObjectPropertyCount;
    }

    public boolean isEmpty() {
        return this.indexedClassExpressionLookup.isEmpty() && this.indexedPropertyChainLookup.isEmpty() && this.indexedAxiomLookup.isEmpty();
    }

    public void subtract(IndexedObjectCache other) {
        for (IndexedClassExpression ice : other.indexedClassExpressionLookup) {
            if (ice.getCompositionRuleHead() != null) {
                throw new ElkUnexpectedIndexingException("Deleting object with registered rules: " + ice);
            }
            Context context = ice.getContext();
            if (context != null) {
                context.removeLinks();
            }
            if (ice.accept(this.deletor).booleanValue()) continue;
            throw new ElkUnexpectedIndexingException("Cannot remove indexed object from the cache " + ice);
        }
        for (IndexedPropertyChain ipc : other.indexedPropertyChainLookup) {
            if (ipc.accept(this.deletor).booleanValue()) continue;
            throw new ElkUnexpectedIndexingException("Cannot remove indexed object from the cache " + ipc);
        }
        for (IndexedAxiom ax : other.indexedAxiomLookup) {
            if (ax.accept(this.deletor).booleanValue()) continue;
            throw new ElkUnexpectedIndexingException("Cannot remove indexed object from the cache " + ax);
        }
    }

    @Override
    public IndexedClass visit(IndexedClass element) {
        return IndexedObjectCache.resolveCache((IndexedClass)this.indexedClassExpressionLookup.get(element), element);
    }

    @Override
    public IndexedIndividual visit(IndexedIndividual element) {
        return IndexedObjectCache.resolveCache((IndexedIndividual)this.indexedClassExpressionLookup.get(element), element);
    }

    @Override
    public IndexedObjectComplementOf visit(IndexedObjectComplementOf element) {
        return IndexedObjectCache.resolveCache((IndexedObjectComplementOf)this.indexedClassExpressionLookup.get(element), element);
    }

    @Override
    public IndexedObjectIntersectionOf visit(IndexedObjectIntersectionOf element) {
        return IndexedObjectCache.resolveCache((IndexedObjectIntersectionOf)this.indexedClassExpressionLookup.get(element), element);
    }

    @Override
    public IndexedObjectSomeValuesFrom visit(IndexedObjectSomeValuesFrom element) {
        return IndexedObjectCache.resolveCache((IndexedObjectSomeValuesFrom)this.indexedClassExpressionLookup.get(element), element);
    }

    @Override
    public IndexedObjectUnionOf visit(IndexedObjectUnionOf element) {
        return IndexedObjectCache.resolveCache((IndexedObjectUnionOf)this.indexedClassExpressionLookup.get(element), element);
    }

    @Override
    public IndexedDataHasValue visit(IndexedDataHasValue element) {
        return IndexedObjectCache.resolveCache((IndexedDataHasValue)this.indexedClassExpressionLookup.get(element), element);
    }

    @Override
    public IndexedObjectProperty visit(IndexedObjectProperty element) {
        return IndexedObjectCache.resolveCache((IndexedObjectProperty)this.indexedPropertyChainLookup.get(element), element);
    }

    @Override
    public IndexedBinaryPropertyChain visit(IndexedBinaryPropertyChain element) {
        return IndexedObjectCache.resolveCache((IndexedBinaryPropertyChain)this.indexedPropertyChainLookup.get(element), element);
    }

    @Override
    public IndexedSubClassOfAxiom visit(IndexedSubClassOfAxiom axiom) {
        return axiom;
    }

    @Override
    public IndexedDisjointnessAxiom visit(IndexedDisjointnessAxiom axiom) {
        return IndexedObjectCache.resolveCache((IndexedDisjointnessAxiom)this.indexedAxiomLookup.get(axiom), axiom);
    }

    private static <T> T resolveCache(T cached, T element) {
        return cached == null ? element : cached;
    }

    private class IndexedPropertyChainViewFactory
    implements KeyEntryFactory<IndexedPropertyChain> {
        final IndexedEntryConverter<IndexedPropertyChain> converter = new IndexedEntryConverter();

        private IndexedPropertyChainViewFactory() {
        }

        @Override
        public KeyEntry<IndexedPropertyChain, ? extends IndexedPropertyChain> createEntry(IndexedPropertyChain key) {
            return (KeyEntry)((Object)key.accept(this.converter));
        }
    }

    private class IndexedClassExpressionViewFactory
    implements KeyEntryFactory<IndexedClassExpression> {
        final IndexedEntryConverter<IndexedClassExpression> converter = new IndexedEntryConverter();

        private IndexedClassExpressionViewFactory() {
        }

        @Override
        public KeyEntry<IndexedClassExpression, ? extends IndexedClassExpression> createEntry(IndexedClassExpression key) {
            return (KeyEntry)((Object)key.accept(this.converter));
        }
    }

    private class IndexedAxiomViewFactory
    implements KeyEntryFactory<IndexedAxiom> {
        final IndexedEntryConverter<IndexedAxiom> converter = new IndexedEntryConverter();

        private IndexedAxiomViewFactory() {
        }

        @Override
        public KeyEntry<IndexedAxiom, ? extends IndexedAxiom> createEntry(IndexedAxiom key) {
            return (KeyEntry)((Object)key.accept(this.converter));
        }
    }
}

