/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedObjectUnionOfVisitor;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.NegativeSubsumer;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;
import org.semanticweb.elk.util.logging.ElkMessage;

public class IndexedObjectUnionOf
extends IndexedClassExpression {
    protected static final Logger LOGGER_ = Logger.getLogger(IndexedObjectUnionOf.class);
    private final Set<IndexedClassExpression> disjuncts_ = new ArrayHashSet<IndexedClassExpression>(2);

    IndexedObjectUnionOf(List<IndexedClassExpression> disjuncts) {
        for (IndexedClassExpression disjunct : disjuncts) {
            this.disjuncts_.add(disjunct);
        }
    }

    public Set<IndexedClassExpression> getDisjuncts() {
        return this.disjuncts_;
    }

    public <O> O accept(IndexedObjectUnionOfVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(IndexedClassExpressionVisitor<O> visitor) {
        return this.accept((IndexedObjectUnionOfVisitor<O>)visitor);
    }

    @Override
    void updateOccurrenceNumbers(ModifiableOntologyIndex index, int increment, int positiveIncrement, int negativeIncrement) {
        if (this.negativeOccurrenceNo == 0 && negativeIncrement > 0) {
            for (IndexedClassExpression disjunct : this.disjuncts_) {
                index.add(disjunct, new ThisCompositionRule(this));
            }
        }
        if (this.positiveOccurrenceNo == 0 && positiveIncrement > 0 && LOGGER_.isEnabledFor((Priority)Level.WARN)) {
            LOGGER_.warn((Object)ElkMessage.serialize("reasoner.indexing.IndexedObjectUnionOf", "ELK does not support positive occurrences of ObjectUnionOf. Reasoning might be incomplete!"));
        }
        this.positiveOccurrenceNo += positiveIncrement;
        this.negativeOccurrenceNo += negativeIncrement;
        this.checkOccurrenceNumbers();
        if (this.negativeOccurrenceNo == 0 && negativeIncrement < 0) {
            for (IndexedClassExpression disjunct : this.disjuncts_) {
                index.remove(disjunct, new ThisCompositionRule(this));
            }
        }
    }

    @Override
    public void accept(DecompositionRuleApplicationVisitor visitor, Context context) {
    }

    @Override
    public String toStringStructural() {
        return "ObjectUnionOf(" + this.disjuncts_ + ')';
    }

    public static class ThisCompositionRule
    extends ModifiableLinkImpl<ChainableRule<Context>>
    implements ChainableRule<Context> {
        private static final String NAME = "ObjectUnionOf Introduction";
        private final Set<IndexedClassExpression> disjunctions_ = new ArrayHashSet<IndexedClassExpression>();
        private static final Matcher<ChainableRule<Context>, ThisCompositionRule> MATCHER_ = new SimpleTypeBasedMatcher<ChainableRule<Context>, ThisCompositionRule>(ThisCompositionRule.class);
        private static final ReferenceFactory<ChainableRule<Context>, ThisCompositionRule> FACTORY_ = new ReferenceFactory<ChainableRule<Context>, ThisCompositionRule>(){

            @Override
            public ThisCompositionRule create(ChainableRule<Context> tail) {
                return new ThisCompositionRule(tail);
            }
        };

        private ThisCompositionRule(ChainableRule<Context> tail) {
            super(tail);
        }

        ThisCompositionRule(IndexedClassExpression disjunction) {
            this((ChainableRule<Context>)null);
            this.disjunctions_.add(disjunction);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, Context context) {
            visitor.visit(this, writer, context);
        }

        public Set<IndexedClassExpression> getDisjunctions() {
            return this.disjunctions_;
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Applying ObjectUnionOf Introduction to " + context));
            }
            for (IndexedClassExpression disjunction : this.disjunctions_) {
                writer.produce(context, new NegativeSubsumer(disjunction));
            }
        }

        @Override
        public boolean addTo(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = ruleChain.getCreate(MATCHER_, FACTORY_);
            return rule.disjunctions_.addAll(this.disjunctions_);
        }

        @Override
        public boolean removeFrom(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = ruleChain.find(MATCHER_);
            boolean changed = false;
            if (rule != null) {
                changed = rule.disjunctions_.removeAll(this.disjunctions_);
                if (rule.isEmpty()) {
                    ruleChain.remove(MATCHER_);
                }
            }
            return changed;
        }

        private boolean isEmpty() {
            return this.disjunctions_.isEmpty();
        }
    }
}

