/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObject;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedObjectVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitorEx;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.util.hashing.HashGenerator;

public abstract class IndexedPropertyChain
extends IndexedObject
implements Comparable<IndexedPropertyChain> {
    protected static final Logger LOGGER_ = Logger.getLogger(IndexedPropertyChain.class);
    int occurrenceNo = 0;
    private final int hashCode_ = HashGenerator.generateNextHashCode();
    private volatile SaturatedPropertyChain saturated_ = null;
    private List<IndexedObjectProperty> toldSuperProperties_;
    private Collection<IndexedBinaryPropertyChain> rightChains_;

    public List<IndexedObjectProperty> getToldSuperProperties() {
        return this.toldSuperProperties_ == null ? Collections.emptyList() : Collections.unmodifiableList(this.toldSuperProperties_);
    }

    public Collection<IndexedBinaryPropertyChain> getRightChains() {
        return this.rightChains_ == null ? Collections.emptySet() : Collections.unmodifiableCollection(this.rightChains_);
    }

    void addToldSuperObjectProperty(IndexedObjectProperty superObjectProperty) {
        if (this.toldSuperProperties_ == null) {
            this.toldSuperProperties_ = new ArrayList<IndexedObjectProperty>(1);
        }
        this.toldSuperProperties_.add(superObjectProperty);
    }

    protected boolean removeToldSuperObjectProperty(IndexedObjectProperty superObjectProperty) {
        boolean success = false;
        if (this.toldSuperProperties_ != null) {
            success = this.toldSuperProperties_.remove(superObjectProperty);
            if (this.toldSuperProperties_.isEmpty()) {
                this.toldSuperProperties_ = null;
            }
        }
        return success;
    }

    protected void addRightChain(IndexedBinaryPropertyChain chain) {
        if (this.rightChains_ == null) {
            this.rightChains_ = new ArrayList<IndexedBinaryPropertyChain>(1);
        }
        this.rightChains_.add(chain);
    }

    protected boolean removeRightChain(IndexedBinaryPropertyChain chain) {
        boolean success = false;
        if (this.rightChains_ != null) {
            success = this.rightChains_.remove(chain);
            if (this.rightChains_.isEmpty()) {
                this.rightChains_ = null;
            }
        }
        return success;
    }

    abstract void updateOccurrenceNumber(int var1);

    @Override
    public boolean occurs() {
        return this.occurrenceNo > 0;
    }

    public String printOccurrenceNumbers() {
        return "[all=" + this.occurrenceNo + "]";
    }

    public void checkOccurrenceNumbers() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + " occurences: " + this.printOccurrenceNumbers()));
        }
        if (this.occurrenceNo < 0) {
            throw new ElkUnexpectedIndexingException(this + " has a negative occurrence: " + this.printOccurrenceNumbers());
        }
    }

    public void updateAndCheckOccurrenceNumbers(int increment) {
        this.updateOccurrenceNumber(increment);
        this.checkOccurrenceNumbers();
    }

    public SaturatedPropertyChain getSaturated() {
        return this.saturated_;
    }

    public synchronized SaturatedPropertyChain setSaturated(SaturatedPropertyChain saturatedObjectProperty) {
        if (this.saturated_ != null) {
            return this.saturated_;
        }
        if (saturatedObjectProperty == null) {
            throw new ElkUnexpectedIndexingException(this + ": cannot assign null saturation");
        }
        this.saturated_ = saturatedObjectProperty;
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": saturation assinged"));
        }
        return null;
    }

    public synchronized void resetSaturated() {
        this.saturated_ = null;
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": saturation removed"));
        }
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    @Override
    public int compareTo(IndexedPropertyChain o) {
        if (this == o) {
            return 0;
        }
        if (this.hashCode_ == o.hashCode_) {
            return this.toString().compareTo(o.toString());
        }
        return this.hashCode_ < o.hashCode_ ? -1 : 1;
    }

    public abstract <O> O accept(IndexedPropertyChainVisitor<O> var1);

    @Override
    public <O> O accept(IndexedObjectVisitor<O> visitor) {
        return this.accept((IndexedPropertyChainVisitor<O>)visitor);
    }

    public abstract <O, P> O accept(IndexedPropertyChainVisitorEx<O, P> var1, P var2);
}

