/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.util.collections.AbstractHashMultimap;
import org.semanticweb.elk.util.collections.Multimap;
import org.semanticweb.elk.util.collections.Operations;

public class SaturatedPropertyChain {
    public static final boolean REPLACE_CHAINS_BY_TOLD_SUPER_PROPERTIES = true;
    public static final boolean ELIMINATE_IMPLIED_COMPOSITIONS = true;
    final IndexedPropertyChain root;
    private volatile boolean isDerivedReflexive_ = false;
    Set<IndexedPropertyChain> derivedSubProperties;
    AbstractHashMultimap<IndexedPropertyChain, IndexedPropertyChain> compositionsByLeftSubProperty;
    AbstractHashMultimap<IndexedPropertyChain, IndexedPropertyChain> compositionsByRightSubProperty;
    private static final IndexedPropertyChainVisitor<Boolean> TOLD_SUPER_PROPERRTY_CHECKER_ = new IndexedPropertyChainVisitor<Boolean>(){

        @Override
        public Boolean visit(IndexedObjectProperty element) {
            return true;
        }

        @Override
        public Boolean visit(IndexedBinaryPropertyChain element) {
            return !element.getRightChains().isEmpty();
        }
    };

    public SaturatedPropertyChain(IndexedPropertyChain ipc) {
        this.root = ipc;
    }

    public void clear() {
        this.isDerivedReflexive_ = false;
        this.derivedSubProperties = null;
        this.compositionsByLeftSubProperty = null;
        this.compositionsByRightSubProperty = null;
    }

    public boolean isClear() {
        return !this.isDerivedReflexive_ && this.derivedSubProperties == null && this.compositionsByLeftSubProperty == null && this.compositionsByRightSubProperty == null;
    }

    public SaturatedPropertyChain clone() {
        SaturatedPropertyChain result = new SaturatedPropertyChain(this.root);
        result.isDerivedReflexive_ = this.isDerivedReflexive_;
        result.derivedSubProperties = this.derivedSubProperties;
        result.compositionsByLeftSubProperty = this.compositionsByLeftSubProperty;
        result.compositionsByRightSubProperty = this.compositionsByRightSubProperty;
        return result;
    }

    public Set<IndexedPropertyChain> getSubProperties() {
        return this.derivedSubProperties == null ? Collections.singleton(this.root) : this.derivedSubProperties;
    }

    public boolean isDerivedReflexive() {
        return this.isDerivedReflexive_;
    }

    public Multimap<IndexedPropertyChain, IndexedPropertyChain> getCompositionsByLeftSubProperty() {
        return this.compositionsByLeftSubProperty == null ? Operations.emptyMultimap() : this.compositionsByLeftSubProperty;
    }

    public Multimap<IndexedPropertyChain, IndexedPropertyChain> getCompositionsByRightSubProperty() {
        return this.compositionsByRightSubProperty == null ? Operations.emptyMultimap() : this.compositionsByRightSubProperty;
    }

    synchronized boolean setReflexive() {
        if (this.isDerivedReflexive_) {
            return false;
        }
        this.isDerivedReflexive_ = true;
        return true;
    }

    public static SaturatedPropertyChain getCreate(IndexedPropertyChain ipc) {
        SaturatedPropertyChain previous;
        SaturatedPropertyChain saturated = ipc.getSaturated();
        if (saturated == null && (previous = ipc.setSaturated(saturated = new SaturatedPropertyChain(ipc))) != null) {
            return previous;
        }
        return saturated;
    }

    public static boolean isRelevant(IndexedPropertyChain ipc) {
        return ipc.accept(TOLD_SUPER_PROPERRTY_CHECKER_);
    }

    public void dumpDiff(SaturatedPropertyChain other, Writer writer) throws IOException {
        if (this.root != other.root) {
            writer.append("this root: " + this.root + "; other root: " + other.root + "\n");
        }
        if (this.isDerivedReflexive_ != other.isDerivedReflexive_) {
            writer.append(this.root + ": this reflexive: " + this.isDerivedReflexive_ + "; other relfexive: " + other.isDerivedReflexive_ + "\n");
        }
        Operations.dumpDiff(this.getSubProperties(), other.getSubProperties(), writer, this.root + ": this sub-property not in other: ");
        Operations.dumpDiff(other.getSubProperties(), this.getSubProperties(), writer, this.root + ": other sub-property not in this: ");
        Operations.dumpDiff(this.getCompositionsByLeftSubProperty(), other.getCompositionsByLeftSubProperty(), writer, this.root + ": this left composition not in other: ");
        Operations.dumpDiff(other.getCompositionsByLeftSubProperty(), this.getCompositionsByLeftSubProperty(), writer, this.root + ": other left composition not in this: ");
        Operations.dumpDiff(this.getCompositionsByRightSubProperty(), other.getCompositionsByRightSubProperty(), writer, this.root + ": this right composition not in other: ");
        Operations.dumpDiff(other.getCompositionsByRightSubProperty(), this.getCompositionsByRightSubProperty(), writer, this.root + ": other right composition not in this: ");
    }
}

