/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableInstanceTaxonomy;

public class InstanceTaxonomyState {
    private UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy_ = null;
    private final Set<ElkNamedIndividual> modifiedIndividuals = Collections.newSetFromMap(new ConcurrentHashMap());
    private final List<IndexedIndividual> removedIndividuals = new LinkedList<IndexedIndividual>();

    public UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> getTaxonomy() {
        return this.taxonomy_;
    }

    Set<ElkNamedIndividual> getModifiedIndividuals() {
        return this.modifiedIndividuals;
    }

    Collection<IndexedIndividual> getRemovedIndividuals() {
        return this.removedIndividuals;
    }

    void initTaxonomy(UpdateableInstanceTaxonomy<ElkClass, ElkNamedIndividual> instanceTaxonomy) {
        this.taxonomy_ = instanceTaxonomy;
    }

    public Writer getWriter() {
        return new Writer();
    }

    public class Writer {
        public void clearTaxonomy() {
            InstanceTaxonomyState.this.taxonomy_ = null;
        }

        public void markModifiedIndividuals(Collection<ElkNamedIndividual> individuals) {
            InstanceTaxonomyState.this.modifiedIndividuals.addAll(individuals);
        }

        public void markRemovedIndividual(IndexedIndividual individual) {
            InstanceTaxonomyState.this.removedIndividuals.add(individual);
        }

        public void clearModifiedIndividuals() {
            InstanceTaxonomyState.this.modifiedIndividuals.clear();
        }

        public void clearRemovedIndividuals() {
            InstanceTaxonomyState.this.removedIndividuals.clear();
        }

        public void clear() {
            this.clearTaxonomy();
            this.clearModifiedIndividuals();
            this.clearRemovedIndividuals();
        }
    }
}

