/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.util.Comparators;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNodeUtils;
import org.semanticweb.elk.reasoner.taxonomy.model.UpdateableTaxonomyNode;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.hashing.HashGenerator;

class NonBottomClassNode
implements UpdateableTaxonomyNode<ElkClass> {
    private static final Logger LOGGER_ = Logger.getLogger(NonBottomClassNode.class);
    private final ConcurrentClassTaxonomy taxonomy_;
    private final List<ElkClass> members_;
    private final Set<UpdateableTaxonomyNode<ElkClass>> directSuperNodes_;
    private final Set<UpdateableTaxonomyNode<ElkClass>> directSubNodes_;
    private final AtomicBoolean modified_ = new AtomicBoolean(true);
    private final int hashCode_ = HashGenerator.generateNextHashCode();

    protected NonBottomClassNode(ConcurrentClassTaxonomy taxonomy, Collection<ElkClass> members) {
        this.taxonomy_ = taxonomy;
        this.members_ = new ArrayList<ElkClass>(members);
        this.directSubNodes_ = new ArrayHashSet<UpdateableTaxonomyNode<ElkClass>>();
        this.directSuperNodes_ = new ArrayHashSet<UpdateableTaxonomyNode<ElkClass>>();
        Collections.sort(this.members_, Comparators.ELK_CLASS_COMPARATOR);
    }

    @Override
    public synchronized void addDirectSuperNode(UpdateableTaxonomyNode<ElkClass> superNode) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": new direct super-node " + superNode));
        }
        this.directSuperNodes_.add(superNode);
    }

    @Override
    public synchronized void addDirectSubNode(UpdateableTaxonomyNode<ElkClass> subNode) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": new direct sub-node " + subNode));
        }
        if (this.directSubNodes_.isEmpty()) {
            this.taxonomy_.countNodesWithSubClasses.incrementAndGet();
        }
        this.directSubNodes_.add(subNode);
    }

    @Override
    public Set<ElkClass> getMembers() {
        return new AbstractSet<ElkClass>(){

            @Override
            public boolean contains(Object arg) {
                if (arg instanceof ElkClass) {
                    return Collections.binarySearch(NonBottomClassNode.this.members_, (ElkClass)arg, Comparators.ELK_CLASS_COMPARATOR) >= 0;
                }
                return false;
            }

            @Override
            public boolean isEmpty() {
                return NonBottomClassNode.this.members_.isEmpty();
            }

            @Override
            public Iterator<ElkClass> iterator() {
                return NonBottomClassNode.this.members_.iterator();
            }

            @Override
            public int size() {
                return NonBottomClassNode.this.members_.size();
            }
        };
    }

    @Override
    public ElkClass getCanonicalMember() {
        return this.members_.get(0);
    }

    @Override
    public Set<UpdateableTaxonomyNode<ElkClass>> getDirectSuperNodes() {
        return this.getDirectUpdateableSuperNodes();
    }

    @Override
    public Set<UpdateableTaxonomyNode<ElkClass>> getDirectUpdateableSuperNodes() {
        return Collections.unmodifiableSet(this.directSuperNodes_);
    }

    @Override
    public Set<? extends TaxonomyNode<ElkClass>> getAllSuperNodes() {
        return TaxonomyNodeUtils.getAllSuperNodes(this);
    }

    @Override
    public Set<TaxonomyNode<ElkClass>> getDirectSubNodes() {
        if (!this.directSubNodes_.isEmpty()) {
            return Collections.unmodifiableSet(this.directSubNodes_);
        }
        return Collections.singleton(this.taxonomy_.getBottomNode());
    }

    @Override
    public Set<UpdateableTaxonomyNode<ElkClass>> getDirectUpdateableSubNodes() {
        return Collections.unmodifiableSet(this.directSubNodes_);
    }

    @Override
    public Set<? extends TaxonomyNode<ElkClass>> getAllSubNodes() {
        return TaxonomyNodeUtils.getAllSubNodes(this);
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    public String toString() {
        return this.members_.toString();
    }

    public void setMembers(Collection<ElkClass> members) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": updating members to " + members));
        }
        this.members_.clear();
        this.members_.addAll(members);
        Collections.sort(this.members_, Comparators.ELK_CLASS_COMPARATOR);
    }

    @Override
    public boolean trySetModified(boolean modified) {
        boolean result = this.modified_.compareAndSet(!modified, modified);
        if (result && LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("node " + this + ": set " + (modified ? "modified" : "not modifiled")));
        }
        return result;
    }

    @Override
    public boolean isModified() {
        return this.modified_.get();
    }

    @Override
    public boolean removeDirectSubNode(UpdateableTaxonomyNode<ElkClass> subNode) {
        boolean changed = this.directSubNodes_.remove(subNode);
        if (changed && LOGGER_.isTraceEnabled() && LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": removed direct sub-node " + subNode));
        }
        if (this.directSubNodes_.isEmpty()) {
            this.taxonomy_.countNodesWithSubClasses.decrementAndGet();
        }
        return changed;
    }

    @Override
    public boolean removeDirectSuperNode(UpdateableTaxonomyNode<ElkClass> superNode) {
        boolean changed = this.directSuperNodes_.remove(superNode);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)(this + ": removed direct super-node " + superNode));
        }
        return changed;
    }
}

