/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.reasoner.taxonomy.OrphanTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.SingletoneTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.collections.ArrayHashMap;

public class SingletoneInstanceTaxonomy<T extends ElkObject, I extends ElkObject, N extends OrphanTypeNode<T, I>>
extends SingletoneTaxonomy<T, N>
implements InstanceTaxonomy<T, I> {
    final Map<I, InstanceNode<T, I>> instanceNodeLookup;

    public SingletoneInstanceTaxonomy(N node) {
        super(node);
        this.instanceNodeLookup = new ArrayHashMap<I, InstanceNode<T, I>>(((OrphanTypeNode)node).getAllInstanceNodes().size());
        for (InstanceNode instanceNode : ((OrphanTypeNode)node).getAllInstanceNodes()) {
            for (ElkObject instance : instanceNode.getMembers()) {
                this.instanceNodeLookup.put(instance, instanceNode);
            }
        }
    }

    @Override
    public TypeNode<T, I> getTopNode() {
        return (TypeNode)((Object)this.node);
    }

    @Override
    public TypeNode<T, I> getBottomNode() {
        return (TypeNode)((Object)this.node);
    }

    @Override
    public TypeNode<T, I> getTypeNode(T elkObject) {
        if (((OrphanTypeNode)this.node).getMembers().contains(elkObject)) {
            return (TypeNode)((Object)this.node);
        }
        return null;
    }

    @Override
    public Set<? extends TypeNode<T, I>> getTypeNodes() {
        return Collections.singleton(this.node);
    }

    @Override
    public InstanceNode<T, I> getInstanceNode(I elkObject) {
        return this.instanceNodeLookup.get(elkObject);
    }

    @Override
    public Set<? extends InstanceNode<T, I>> getInstanceNodes() {
        return ((OrphanTypeNode)this.node).instanceNodes;
    }
}

