/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.formats;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.semanticweb.owlapi.formats.AbstractRDFPrefixDocumentFormat;
import org.semanticweb.owlapi.formats.RioRDFDocumentFormat;
import org.semanticweb.owlapi.model.MIMETypeAware;

public class RioRDFPrefixDocumentFormat
extends AbstractRDFPrefixDocumentFormat
implements MIMETypeAware,
RioRDFDocumentFormat {
    private static final long serialVersionUID = 40000L;
    private transient RDFFormat format;
    private final String formatName;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (RDFFormat f : RDFParserRegistry.getInstance().getKeys()) {
            if (!f.getName().equals(this.formatName)) continue;
            this.format = f;
            return;
        }
    }

    public RioRDFPrefixDocumentFormat(RDFFormat format) {
        this.format = format;
        this.formatName = this.format.getName();
    }

    public String getKey() {
        String name = this.format.getName();
        assert (name != null);
        return name;
    }

    @Override
    public RDFFormat getRioFormat() {
        return this.format;
    }

    public String getDefaultMIMEType() {
        return this.format.getDefaultMIMEType();
    }

    public List<String> getMIMETypes() {
        List mimeTypes = this.format.getMIMETypes();
        assert (mimeTypes != null);
        return mimeTypes;
    }

    public boolean handlesMimeType(String mimeType) {
        return this.format.hasMIMEType(mimeType);
    }
}

