/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.protege.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerInfo;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.semanticweb.elk.owlapi.ElkReasoner;
import org.semanticweb.elk.protege.ElkProtegeConfigurationUtils;
import org.semanticweb.elk.protege.ProtegeReasonerFactory;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class ElkPreferencesPanel
extends OWLPreferencesPanel {
    private static final long serialVersionUID = -5568211860560307648L;
    private JSpinner nwSpinner;
    private JCheckBox incCheckbox_;

    public void initialise() throws Exception {
        ReasonerConfiguration elkConfig = ElkProtegeConfigurationUtils.loadConfiguration();
        this.setLayout(new BorderLayout());
        JPanel numOfWorkersPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int gridybase = 0;
        int numOfWorkers = elkConfig.getParameterAsInt("elk.reasoner.number_of_workers");
        this.nwSpinner = new JSpinner(new SpinnerNumberModel(numOfWorkers, 1, 100, 1));
        gridybase = this.buildNumOfWorkers(numOfWorkersPanel, c, gridybase);
        boolean incrementalModeAllowed = elkConfig.getParameterAsBoolean("elk.reasoner.incremental.allowed");
        this.incCheckbox_ = new JCheckBox("", incrementalModeAllowed);
        gridybase = this.buildIncrementalModeAllowed(numOfWorkersPanel, c, gridybase);
        Box mainPanel = new Box(3);
        mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Reasoner settings"), BorderFactory.createEmptyBorder(7, 7, 7, 7)));
        mainPanel.add(numOfWorkersPanel);
        mainPanel.setAlignmentX(0.0f);
        Box holder = new Box(3);
        holder.add(mainPanel);
        this.add(holder, "North");
        this.applyChanges();
    }

    private int buildNumOfWorkers(JPanel panel, GridBagConstraints c, int gridybase) {
        c.gridx = 0;
        c.gridy = ++gridybase;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 12);
        c.anchor = 23;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("Number of working threads:"), c);
        c.gridx = 1;
        c.gridy = gridybase;
        c.insets = new Insets(0, 0, 5, 0);
        c.weightx = 1.0;
        panel.add((Component)this.nwSpinner, c);
        return gridybase;
    }

    private int buildIncrementalModeAllowed(JPanel panel, GridBagConstraints c, int gridybase) {
        c.gridx = 0;
        c.gridy = ++gridybase;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 12);
        c.anchor = 23;
        c.weightx = 0.0;
        panel.add((Component)new JLabel("<html>Incremental reasoning<br/>(experimental)</html>"), c);
        c.gridx = 1;
        c.gridy = gridybase;
        c.insets = new Insets(0, 0, 5, 0);
        c.weightx = 1.0;
        panel.add((Component)this.incCheckbox_, c);
        return gridybase;
    }

    public void applyChanges() {
        OWLReasoner reasoner;
        ReasonerConfiguration elkConfig = this.getCurrentReasonerConfiguration();
        if (elkConfig != null) {
            elkConfig.setParameter("elk.reasoner.number_of_workers", this.nwSpinner.getValue().toString());
            elkConfig.setParameter("elk.reasoner.incremental.allowed", String.valueOf(this.incCheckbox_.isSelected()));
        }
        if ((reasoner = this.getOWLModelManager().getOWLReasonerManager().getCurrentReasoner()) instanceof ElkReasoner) {
            ((ElkReasoner)reasoner).setConfigurationOptions(elkConfig);
        }
    }

    public void dispose() throws Exception {
        ElkProtegeConfigurationUtils.saveConfiguration(this.getCurrentReasonerConfiguration());
    }

    private ReasonerConfiguration getCurrentReasonerConfiguration() {
        ProtegeOWLReasonerInfo reasonerInfo = this.getOWLModelManager().getOWLReasonerManager().getCurrentReasonerFactory();
        if (!(reasonerInfo instanceof ProtegeReasonerFactory)) {
            return null;
        }
        ProtegeReasonerFactory elkFactory = (ProtegeReasonerFactory)reasonerInfo;
        return elkFactory.getElkConfiguration();
    }
}

