/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractShortCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ShortArrays;
import com.carrotsearch.hppcrt.ShortContainer;
import com.carrotsearch.hppcrt.ShortLookupContainer;
import com.carrotsearch.hppcrt.ShortSet;
import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;
import com.carrotsearch.hppcrt.procedures.ShortProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortHashSet
extends AbstractShortCollection
implements ShortLookupContainer,
ShortSet,
Cloneable {
    public short[] keys;
    public boolean allocatedDefaultKey = false;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ShortCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ShortHashSet.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public ShortHashSet() {
        this(8, 0.75);
    }

    public ShortHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ShortHashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ShortHashSet(ShortContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(short key) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                return false;
            }
            this.allocatedDefaultKey = true;
            return true;
        }
        int mask = this.keys.length - 1;
        short[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(key, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
        }
        return true;
    }

    public int add(short e1, short e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(short ... elements) {
        int count = 0;
        for (short e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addAll(ShortContainer container) {
        return this.addAll((Iterable<? extends ShortCursor>)container);
    }

    @Override
    public int addAll(Iterable<? extends ShortCursor> iterable) {
        int count = 0;
        for (ShortCursor shortCursor : iterable) {
            if (!this.add(shortCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(short pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != 0);
        short[] oldKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        int mask = this.keys.length - 1;
        short key = 0;
        int slot = -1;
        short[] keys = this.keys;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == 0) continue;
            slot = BitMixer.mix(key, perturb) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            short[] keys = new short[capacity];
            this.keys = keys;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int removeAll(short key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public boolean remove(short key) {
        short existing;
        if (key == 0) {
            if (this.allocatedDefaultKey) {
                this.allocatedDefaultKey = false;
                return true;
            }
            return false;
        }
        int mask = this.keys.length - 1;
        short[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int slot;
        short existing;
        int mask = this.keys.length - 1;
        short[] keys = this.keys;
        int perturb = this.perturbation;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    @Override
    public boolean contains(short key) {
        short existing;
        if (key == 0) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        short[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while ((existing = keys[slot]) != 0) {
            if (key == existing) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ShortArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    public int hashCode() {
        int h = 0;
        short[] keys = this.keys;
        int i = keys.length;
        while (--i >= 0) {
            short existing = keys[i];
            if (existing == 0) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ShortSet other = (ShortSet)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(((ShortCursor)it.next()).value)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply((short)0);
        }
        short[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0; --i) {
            short existing = keys[i];
            if (existing == 0) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public short[] toArray(short[] target) {
        int count = 0;
        if (this.allocatedDefaultKey) {
            target[count++] = 0;
        }
        short[] keys = this.keys;
        for (int i = 0; i < keys.length; ++i) {
            short existing = keys[i];
            if (existing == 0) continue;
            target[count++] = existing;
        }
        assert (count == this.size());
        return target;
    }

    public ShortHashSet clone() {
        ShortHashSet cloned = new ShortHashSet(this.size(), this.loadFactor);
        cloned.addAll(this);
        return cloned;
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate) {
        short existing;
        if (this.allocatedDefaultKey && !predicate.apply((short)0)) {
            return predicate;
        }
        short[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == 0 || predicate.apply(existing)); --i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply((short)0)) {
            this.allocatedDefaultKey = false;
        }
        short[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            short existing = keys[i];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    public static ShortHashSet from(short ... elements) {
        ShortHashSet set = new ShortHashSet(elements.length);
        set.add(elements);
        return set;
    }

    public static ShortHashSet from(ShortContainer container) {
        return new ShortHashSet(container);
    }

    public static ShortHashSet newInstance() {
        return new ShortHashSet();
    }

    public static ShortHashSet newInstance(int initialCapacity, double loadFactor) {
        return new ShortHashSet(initialCapacity, loadFactor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ShortCursor> {
        public final ShortCursor cursor = new ShortCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ShortCursor fetch() {
            int i;
            if (this.cursor.index == ShortHashSet.this.keys.length + 1) {
                if (ShortHashSet.this.allocatedDefaultKey) {
                    this.cursor.index = ShortHashSet.this.keys.length;
                    this.cursor.value = 0;
                    return this.cursor;
                }
                this.cursor.index = ShortHashSet.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ShortHashSet.this.keys[i] == 0; --i) {
            }
            if (i == -1) {
                return (ShortCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ShortHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

