/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.collections.entryset;

import java.util.AbstractCollection;
import java.util.Iterator;
import org.semanticweb.elk.util.collections.entryset.EntryHashSet;
import org.semanticweb.elk.util.collections.entryset.KeyEntry;
import org.semanticweb.elk.util.collections.entryset.KeyEntryFactory;

public class KeyEntryHashSet<T>
extends AbstractCollection<T> {
    protected final KeyEntryFactory<T> keyEntryFactory;
    protected final EntryHashSet<KeyEntry<T, ? extends T>> entryHashSet;

    public KeyEntryHashSet(KeyEntryFactory<T> keyEntryFactory, int initialCapacity) {
        this.keyEntryFactory = keyEntryFactory;
        this.entryHashSet = new EntryHashSet(initialCapacity);
    }

    public KeyEntryHashSet(KeyEntryFactory<T> keyEntryFactory) {
        this.keyEntryFactory = keyEntryFactory;
        this.entryHashSet = new EntryHashSet();
    }

    public T merge(T key) {
        return this.entryHashSet.mergeEntry(this.keyEntryFactory.createEntry(key)).getKey();
    }

    @Override
    public boolean add(T key) {
        KeyEntry<T, T> entry = this.keyEntryFactory.createEntry(key);
        return entry == this.entryHashSet.mergeEntry(entry);
    }

    public T get(T key) {
        KeyEntry<T, T> entry = this.entryHashSet.getEntry(this.keyEntryFactory.createEntry(key));
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    public T removeEntry(T key) {
        KeyEntry<T, T> entry = this.entryHashSet.removeEntry(this.keyEntryFactory.createEntry(key));
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Deletion not supported");
    }

    @Override
    public void clear() {
        this.entryHashSet.clear();
    }

    @Override
    public int size() {
        return this.entryHashSet.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            final Iterator<KeyEntry<T, ? extends T>> recordIterator;
            {
                this.recordIterator = KeyEntryHashSet.this.entryHashSet.entryIterator();
            }

            @Override
            public boolean hasNext() {
                return this.recordIterator.hasNext();
            }

            @Override
            public T next() {
                return this.recordIterator.next().getKey();
            }

            @Override
            public void remove() {
                this.recordIterator.remove();
            }
        };
    }
}

