/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.reasoner.main;

import de.tudresden.inf.lat.jcel.core.algorithm.common.Processor;
import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.RuleBasedProcessor;
import de.tudresden.inf.lat.jcel.core.graph.IntegerHierarchicalGraph;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityType;
import de.tudresden.inf.lat.jcel.coreontology.datatype.OntologyExpressivity;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.ComplexAxiomExpressivityDetector;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerDataProperty;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerDataPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerDataTypeFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerNamedIndividual;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpressionVisitor;
import de.tudresden.inf.lat.jcel.ontology.normalization.ObjectPropertyIdFinder;
import de.tudresden.inf.lat.jcel.ontology.normalization.OntologyNormalizer;
import de.tudresden.inf.lat.jcel.reasoner.main.IntegerReasoner;
import de.tudresden.inf.lat.jcel.reasoner.main.OntologyEntailmentChecker;
import de.tudresden.inf.lat.jcel.reasoner.main.UnsupportedQueryException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class RuleBasedReasoner
implements IntegerReasoner {
    private static final Logger logger = Logger.getLogger(RuleBasedReasoner.class.getName());
    private final Map<IntegerClassExpression, Integer> auxClassInvMap = new HashMap<IntegerClassExpression, Integer>();
    private final Map<Integer, IntegerClassExpression> auxClassMap = new HashMap<Integer, IntegerClassExpression>();
    private boolean classified = false;
    private final OntologyEntailmentChecker entailmentChecker = new OntologyEntailmentChecker(this);
    private final IntegerOntologyObjectFactory factory;
    private boolean interruptRequested = false;
    private RuleBasedProcessor processor = null;
    private final long timeOut = 0L;

    public RuleBasedReasoner(Set<ComplexIntegerAxiom> ontology, IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(ontology);
        Objects.requireNonNull(factory);
        this.factory = factory;
        this.processor = this.createProcessor(ontology);
    }

    @Override
    public void classify() {
        if (!this.classified) {
            logger.fine("starting classification ...");
            this.flush();
            while (this.processor.process()) {
                if (!this.interruptRequested) continue;
                this.interruptRequested = false;
                throw new RuntimeException("Classification interrupted.");
            }
            logger.fine("classification finished.");
        }
        this.classified = true;
    }

    private RuleBasedProcessor createProcessor(Set<ComplexIntegerAxiom> ontology) {
        logger.fine("creating processor (phase 1) ...");
        ComplexAxiomExpressivityDetector expressivity = new ComplexAxiomExpressivityDetector(ontology);
        logger.fine("description logic family : " + expressivity.toString() + " .");
        HashSet<Integer> originalClassSet = new HashSet<Integer>();
        HashSet<Integer> originalObjectPropertySet = new HashSet<Integer>();
        ontology.forEach(axiom -> {
            originalClassSet.addAll(axiom.getClassesInSignature());
            originalObjectPropertySet.addAll(axiom.getObjectPropertiesInSignature());
        });
        logger.fine("number of axioms : " + ontology.size());
        logger.fine("number of classes : " + originalClassSet.size());
        logger.fine("number of object properties : " + originalObjectPropertySet.size());
        logger.fine("normalizing ontology ...");
        OntologyNormalizer axiomNormalizer = new OntologyNormalizer();
        Set normalizedAxiomSet = axiomNormalizer.normalize(ontology, this.factory);
        logger.fine("creating processor (phase 2) ...");
        RuleBasedProcessor ret = new RuleBasedProcessor(originalObjectPropertySet, originalClassSet, normalizedAxiomSet, (OntologyExpressivity)expressivity, this.factory.getNormalizedAxiomFactory(), this.factory.getEntityManager());
        logger.fine("processor created.");
        return ret;
    }

    @Override
    public void dispose() {
    }

    protected IntegerClass flattenClassExpression(IntegerClassExpression ce) {
        IntegerClass ret = null;
        if (ce instanceof IntegerClass) {
            ret = (IntegerClass)ce;
        } else {
            Integer classIndex = this.auxClassInvMap.get(ce);
            if (Objects.isNull(classIndex)) {
                Integer auxClassId = this.factory.getEntityManager().createAnonymousEntity(IntegerEntityType.CLASS, false);
                ret = this.getDataTypeFactory().createClass(auxClassId.intValue());
                this.auxClassMap.put(auxClassId, ce);
                this.auxClassInvMap.put(ce, auxClassId);
                HashSet<Object> argument = new HashSet<Object>();
                argument.add(ret);
                argument.add(ce);
                HashSet<IntegerEquivalentClassesAxiom> extendedOntology = new HashSet<IntegerEquivalentClassesAxiom>();
                Set annotations = Collections.emptySet();
                extendedOntology.add(this.factory.getComplexAxiomFactory().createEquivalentClassesAxiom(argument, annotations));
                OntologyNormalizer axiomNormalizer = new OntologyNormalizer();
                Set extendedNormalizedAxiomSet = axiomNormalizer.normalize(extendedOntology, this.factory);
                this.processor.addAxioms(extendedNormalizedAxiomSet);
                this.classified = false;
            } else {
                ret = this.getDataTypeFactory().createClass(classIndex.intValue());
            }
        }
        return ret;
    }

    @Override
    public void flush() {
        this.classified = false;
    }

    @Override
    public Set<IntegerClass> getBottomClassNode() {
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getClassHierarchy();
        return this.toIntegerClass(graph.getEquivalents(graph.getBottomElement()));
    }

    @Override
    public Set<IntegerDataProperty> getBottomDataPropertyNode() {
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getDataPropertyHierarchy();
        return this.toIntegerDataProperty(graph.getEquivalents(graph.getBottomElement()));
    }

    @Override
    public Set<IntegerObjectPropertyExpression> getBottomObjectPropertyNode() {
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getObjectPropertyHierarchy();
        return this.toIntegerObjectPropertyExpression(graph.getEquivalents(graph.getBottomElement()));
    }

    @Override
    public Set<Set<IntegerClass>> getDataPropertyDomains(IntegerDataProperty pe, boolean direct) {
        Objects.requireNonNull(pe);
        throw new UnsupportedQueryException("Unsupported query: DataPropertyDomains of " + pe);
    }

    @Override
    public Set<IntegerClass> getDataPropertyValues(IntegerNamedIndividual ind, IntegerDataProperty pe) {
        Objects.requireNonNull(ind);
        Objects.requireNonNull(pe);
        throw new UnsupportedQueryException("Unsupported query: DataPropertyValues of " + ind + "," + pe);
    }

    private IntegerDataTypeFactory getDataTypeFactory() {
        return this.factory.getDataTypeFactory();
    }

    @Override
    public Set<Set<IntegerNamedIndividual>> getDifferentIndividuals(IntegerNamedIndividual ind) {
        Objects.requireNonNull(ind);
        this.classify();
        return null;
    }

    @Override
    public Set<Set<IntegerClass>> getDisjointClasses(IntegerClassExpression ce) {
        Objects.requireNonNull(ce);
        this.classify();
        return null;
    }

    @Override
    public Set<Set<IntegerDataProperty>> getDisjointDataProperties(IntegerDataPropertyExpression pe) {
        Objects.requireNonNull(pe);
        this.classify();
        return null;
    }

    @Override
    public Set<Set<IntegerObjectPropertyExpression>> getDisjointObjectProperties(IntegerObjectPropertyExpression pe) {
        Objects.requireNonNull(pe);
        this.classify();
        return null;
    }

    @Override
    public Set<IntegerClass> getEquivalentClasses(IntegerClassExpression ce) {
        Objects.requireNonNull(ce);
        IntegerClass cls = this.flattenClassExpression(ce);
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getClassHierarchy();
        return this.toIntegerClass(graph.getEquivalents(cls.getId()));
    }

    @Override
    public Set<IntegerDataProperty> getEquivalentDataProperties(IntegerDataProperty pe) {
        Objects.requireNonNull(pe);
        throw new UnsupportedQueryException("Unsupported query: EquivalentDataProperties of " + pe);
    }

    @Override
    public Set<IntegerObjectPropertyExpression> getEquivalentObjectProperties(IntegerObjectPropertyExpression pe) {
        Objects.requireNonNull(pe);
        this.classify();
        Integer propId = this.getObjectPropertyExpressionId(pe);
        IntegerHierarchicalGraph graph = this.getProcessor().getObjectPropertyHierarchy();
        return this.toIntegerObjectPropertyExpression(graph.getEquivalents(propId));
    }

    @Override
    public Set<Set<IntegerNamedIndividual>> getInstances(IntegerClassExpression ce, boolean direct) {
        Objects.requireNonNull(ce);
        HashSet<Set<IntegerNamedIndividual>> ret = new HashSet<Set<IntegerNamedIndividual>>();
        IntegerClass cls = this.flattenClassExpression(ce);
        this.classify();
        Integer classId = cls.getId();
        HashSet<Integer> classIdSet = new HashSet<Integer>();
        classIdSet.add(classId);
        if (!direct) {
            classIdSet.addAll(this.getProcessor().getClassHierarchy().getDescendants(classId));
        }
        HashSet<Integer> indivIdSet = new HashSet<Integer>();
        indivIdSet.addAll(this.getProcessor().getDirectTypes().keySet());
        while (!indivIdSet.isEmpty()) {
            Integer indivId = (Integer)indivIdSet.iterator().next();
            indivIdSet.remove(indivId);
            Set<Integer> types = this.getProcessor().getDirectTypes().get(indivId);
            boolean found = types.contains(classId);
            if (!found && !direct) {
                HashSet<Integer> classIdSetCopy = new HashSet<Integer>();
                classIdSetCopy.addAll(classIdSet);
                classIdSetCopy.retainAll(types);
                boolean bl = found = !classIdSetCopy.isEmpty();
            }
            if (!found) continue;
            Set<Integer> equivIndivId = this.getProcessor().getSameIndividualMap().get(indivId);
            Set<IntegerNamedIndividual> elem = this.toIntegerNamedIndividual(equivIndivId);
            indivIdSet.removeAll(equivIndivId);
            ret.add(elem);
        }
        return ret;
    }

    @Override
    public Set<IntegerObjectPropertyExpression> getInverseObjectProperties(IntegerObjectPropertyExpression pe) {
        Objects.requireNonNull(pe);
        this.classify();
        throw new UnsupportedQueryException("Unsupported query: InverseObjectProperties of " + pe);
    }

    @Override
    public Set<Set<IntegerClass>> getObjectPropertyDomains(IntegerObjectPropertyExpression pe, boolean direct) {
        Objects.requireNonNull(pe);
        this.classify();
        throw new UnsupportedQueryException("Unsupported query: ObjectPropertyDomains of " + pe + "," + direct);
    }

    private Integer getObjectPropertyExpressionId(IntegerObjectPropertyExpression propExpr) {
        return (Integer)propExpr.accept((IntegerObjectPropertyExpressionVisitor)new ObjectPropertyIdFinder(this.factory.getEntityManager()));
    }

    @Override
    public Set<Set<IntegerClass>> getObjectPropertyRanges(IntegerObjectPropertyExpression pe, boolean direct) {
        Objects.requireNonNull(pe);
        this.classify();
        throw new UnsupportedQueryException("Unsupported query: ObjectPropertyRanges of " + pe + "," + direct);
    }

    @Override
    public Set<Set<IntegerNamedIndividual>> getObjectPropertyValues(IntegerNamedIndividual ind, IntegerObjectPropertyExpression pe) {
        Objects.requireNonNull(ind);
        Objects.requireNonNull(pe);
        this.classify();
        throw new UnsupportedQueryException("Unsupported query: ObjectPropertyValues of " + ind + "," + pe);
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public String getReasonerName() {
        return "jcel";
    }

    @Override
    public String getReasonerVersion() {
        return "0.24.1";
    }

    @Override
    public Set<IntegerNamedIndividual> getSameIndividuals(IntegerNamedIndividual ind) {
        Objects.requireNonNull(ind);
        this.classify();
        return this.toIntegerNamedIndividual(this.getProcessor().getSameIndividualMap().get(ind.getId()));
    }

    @Override
    public Set<Set<IntegerClass>> getSubClasses(IntegerClassExpression ce, boolean direct) {
        Objects.requireNonNull(ce);
        IntegerClass cls = this.flattenClassExpression(ce);
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getClassHierarchy();
        Set<Integer> set = null;
        set = direct ? graph.getChildren(cls.getId()) : graph.getDescendants(cls.getId());
        HashSet<Set<IntegerClass>> ret = new HashSet<Set<IntegerClass>>();
        set.forEach(currentElem -> ret.add(this.toIntegerClass(graph.getEquivalents((Integer)currentElem))));
        return ret;
    }

    @Override
    public Set<Set<IntegerDataProperty>> getSubDataProperties(IntegerDataProperty pe, boolean direct) {
        Objects.requireNonNull(pe);
        throw new UnsupportedQueryException("Unsupported query: SubDataProperties of " + pe);
    }

    @Override
    public Set<Set<IntegerObjectPropertyExpression>> getSubObjectProperties(IntegerObjectPropertyExpression pe, boolean direct) {
        Objects.requireNonNull(pe);
        this.classify();
        Integer propId = this.getObjectPropertyExpressionId(pe);
        IntegerHierarchicalGraph graph = this.getProcessor().getObjectPropertyHierarchy();
        Set<Integer> set = null;
        set = direct ? graph.getChildren(propId) : graph.getDescendants(propId);
        HashSet<Set<IntegerObjectPropertyExpression>> ret = new HashSet<Set<IntegerObjectPropertyExpression>>();
        set.forEach(currentElem -> ret.add(this.toIntegerObjectPropertyExpression(graph.getEquivalents((Integer)currentElem))));
        return ret;
    }

    @Override
    public Set<Set<IntegerClass>> getSuperClasses(IntegerClassExpression ce, boolean direct) {
        Objects.requireNonNull(ce);
        IntegerClass cls = this.flattenClassExpression(ce);
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getClassHierarchy();
        Set<Integer> set = null;
        set = direct ? graph.getParents(cls.getId()) : graph.getAncestors(cls.getId());
        HashSet<Set<IntegerClass>> ret = new HashSet<Set<IntegerClass>>();
        set.forEach(currentElem -> {
            Set<Integer> equivalents = graph.getEquivalents((Integer)currentElem);
            ret.add(this.toIntegerClass(equivalents));
        });
        return ret;
    }

    @Override
    public Set<Set<IntegerDataProperty>> getSuperDataProperties(IntegerDataProperty pe, boolean direct) {
        Objects.requireNonNull(pe);
        throw new UnsupportedQueryException("Unsupported query: SuperDataProperties of " + pe);
    }

    @Override
    public Set<Set<IntegerObjectPropertyExpression>> getSuperObjectProperties(IntegerObjectPropertyExpression pe, boolean direct) {
        Objects.requireNonNull(pe);
        this.classify();
        Integer propId = this.getObjectPropertyExpressionId(pe);
        IntegerHierarchicalGraph graph = this.getProcessor().getObjectPropertyHierarchy();
        Set<Integer> set = null;
        set = direct ? graph.getParents(propId) : graph.getAncestors(propId);
        HashSet<Set<IntegerObjectPropertyExpression>> ret = new HashSet<Set<IntegerObjectPropertyExpression>>();
        set.forEach(currentElem -> ret.add(this.toIntegerObjectPropertyExpression(graph.getEquivalents((Integer)currentElem))));
        return ret;
    }

    @Override
    public long getTimeOut() {
        return this.timeOut;
    }

    @Override
    public Set<IntegerClass> getTopClassNode() {
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getClassHierarchy();
        return this.toIntegerClass(graph.getEquivalents(graph.getTopElement()));
    }

    @Override
    public Set<IntegerDataProperty> getTopDataPropertyNode() {
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getDataPropertyHierarchy();
        return this.toIntegerDataProperty(graph.getEquivalents(graph.getTopElement()));
    }

    @Override
    public Set<IntegerObjectPropertyExpression> getTopObjectPropertyNode() {
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getObjectPropertyHierarchy();
        return this.toIntegerObjectPropertyExpression(graph.getEquivalents(graph.getTopElement()));
    }

    @Override
    public Set<Set<IntegerClass>> getTypes(IntegerNamedIndividual ind, boolean direct) {
        Objects.requireNonNull(ind);
        this.classify();
        IntegerHierarchicalGraph graph = this.getProcessor().getClassHierarchy();
        Map<Integer, Set<Integer>> map = this.getProcessor().getDirectTypes();
        Set<Integer> directElemSet = map.get(ind.getId());
        if (Objects.isNull(directElemSet)) {
            directElemSet = Collections.emptySet();
        }
        Set<Integer> set = null;
        if (direct) {
            set = directElemSet;
        } else {
            set = new HashSet<Integer>();
            for (Integer current : directElemSet) {
                set.addAll(graph.getAncestors(current));
            }
        }
        HashSet<Set<IntegerClass>> ret = new HashSet<Set<IntegerClass>>();
        set.forEach(currentElem -> ret.add(this.toIntegerClass(graph.getEquivalents((Integer)currentElem))));
        return ret;
    }

    @Override
    public Set<IntegerClass> getUnsatisfiableClasses() {
        return this.getBottomClassNode();
    }

    @Override
    public void interrupt() {
        this.classified = false;
        this.interruptRequested = true;
    }

    public boolean isClassified() {
        return this.classified;
    }

    @Override
    public boolean isConsistent() {
        this.classify();
        return !this.getUnsatisfiableClasses().contains(this.getProcessor().getClassHierarchy().getTopElement());
    }

    @Override
    public boolean isEntailed(ComplexIntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.classify();
        boolean ret = (Boolean)axiom.accept((ComplexIntegerAxiomVisitor)this.entailmentChecker);
        return ret;
    }

    @Override
    public boolean isEntailed(Set<ComplexIntegerAxiom> axioms) {
        Objects.requireNonNull(axioms);
        this.classify();
        return axioms.stream().allMatch(axiom -> (Boolean)axiom.accept((ComplexIntegerAxiomVisitor)this.entailmentChecker));
    }

    @Override
    public boolean isSatisfiable(IntegerClassExpression classExpression) {
        Objects.requireNonNull(classExpression);
        IntegerClass cls = this.flattenClassExpression(classExpression);
        this.classify();
        return !this.getUnsatisfiableClasses().contains(cls);
    }

    private Set<IntegerClass> toIntegerClass(Set<Integer> set) {
        HashSet<IntegerClass> ret = new HashSet<IntegerClass>();
        set.forEach(elem -> ret.add(this.getDataTypeFactory().createClass(elem.intValue())));
        return ret;
    }

    private Set<IntegerDataProperty> toIntegerDataProperty(Set<Integer> set) {
        HashSet<IntegerDataProperty> ret = new HashSet<IntegerDataProperty>();
        set.forEach(elem -> ret.add(this.getDataTypeFactory().createDataProperty(elem.intValue())));
        return ret;
    }

    private Set<IntegerNamedIndividual> toIntegerNamedIndividual(Set<Integer> set) {
        HashSet<IntegerNamedIndividual> ret = new HashSet<IntegerNamedIndividual>();
        set.forEach(elem -> ret.add(this.getDataTypeFactory().createNamedIndividual(elem.intValue())));
        return ret;
    }

    private Set<IntegerObjectPropertyExpression> toIntegerObjectPropertyExpression(Set<Integer> set) {
        HashSet<IntegerObjectPropertyExpression> ret = new HashSet<IntegerObjectPropertyExpression>();
        set.forEach(elem -> ret.add((IntegerObjectPropertyExpression)this.getDataTypeFactory().createObjectProperty(elem.intValue())));
        return ret;
    }
}

