/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.compact;

import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shacl.compact.reader.ReaderRIOTShaclc;
import org.apache.jena.shacl.compact.writer.WriterRIOTShaclc;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class SHACLC {
    public static void init() {
        ReaderRIOTFactory factoryReader = (language, profile) -> new ReaderRIOTShaclc();
        RDFParserRegistry.registerLangTriples((Lang)Lang.SHACLC, (ReaderRIOTFactory)factoryReader);
        WriterGraphRIOTFactory factoryWriter = rdfFormat -> new WriterRIOTShaclc();
        RDFWriterRegistry.register((RDFFormat)RDFFormat.SHACLC, (WriterGraphRIOTFactory)factoryWriter);
    }

    public static PrefixMap withStandardPrefixes(PrefixMap pmap) {
        PrefixMap pmap2 = PrefixMapFactory.create();
        SHACLC.addStandardPrefixes(pmap2);
        pmap2.putAll(pmap);
        return pmap2;
    }

    public static PrefixMap withStandardPrefixes() {
        PrefixMap pmap = PrefixMapFactory.create();
        return SHACLC.addStandardPrefixes(pmap);
    }

    public static PrefixMap addStandardPrefixes(PrefixMap pmap) {
        pmap.add("rdf", RDF.getURI());
        pmap.add("rdfs", RDFS.getURI());
        pmap.add("sh", SHACL.getURI());
        pmap.add("xsd", XSD.getURI());
        return pmap;
    }

    public static PrefixMapping withStandardPrefixes(PrefixMapping prefixMapping) {
        PrefixMappingImpl pm = new PrefixMappingImpl();
        SHACLC.addStandardPrefixes((PrefixMapping)pm);
        pm.setNsPrefixes(prefixMapping);
        return pm;
    }

    public static void addStandardPrefixes(PrefixMapping prefixMapping) {
        prefixMapping.setNsPrefix("sh", SHACL.getURI());
        prefixMapping.setNsPrefix("rdf", RDF.getURI());
        prefixMapping.setNsPrefix("rdfs", RDFS.getURI());
        prefixMapping.setNsPrefix("xsd", XSD.getURI());
    }
}

