/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintPairwise;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class EqualsConstraint
extends ConstraintPairwise {
    public EqualsConstraint(Node value) {
        super(value, SHACL.EqualsConstraintComponent);
    }

    @Override
    public void validate(ValidationContext vCxt, Shape shape, Node focusNode, Path path, Set<Node> pathNodes, Set<Node> compareNodes) {
        String msg;
        for (Node vn : pathNodes) {
            if (compareNodes.contains(vn)) continue;
            msg = this.toString() + ": not disjoint: value node " + ShLib.displayStr(vn) + " is not in " + compareNodes;
            vCxt.reportEntry(msg, shape, focusNode, path, vn, this);
        }
        for (Node v : compareNodes) {
            if (pathNodes.contains(v)) continue;
            msg = this.toString() + ": not disjoint: value " + ShLib.displayStr(v) + " is not in " + pathNodes;
            vCxt.reportEntry(msg, shape, focusNode, path, v, this);
        }
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compact(out, nodeFmt, "equals", this.value);
    }

    public String toString() {
        return "Equals[" + ShLib.displayStr(this.value) + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, 2);
    }
}

