/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLDataVisitorExAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMacroExpansionVisitor
extends OWLDataVisitorExAdapter<OWLDataRange>
implements OWLClassExpressionVisitorEx<OWLClassExpression>,
OWLDataVisitorEx<OWLDataRange>,
OWLAxiomVisitorEx<OWLAxiom> {
    static final Logger LOG = LoggerFactory.getLogger(AbstractMacroExpansionVisitor.class);
    static final Set<OWLAnnotation> EMPTY_ANNOTATIONS = Collections.emptySet();
    final OWLDataFactory dataFactory;
    @Nonnull
    final Map<IRI, String> expandAssertionToMap;
    @Nonnull
    final Map<IRI, String> expandExpressionMap;
    protected final OWLAnnotationProperty OIO_ISEXPANSION;
    protected final OWLAnnotation expansionMarkerAnnotation;
    private boolean shouldAddExpansionMarker = false;

    public OWLAnnotationProperty getOIO_ISEXPANSION() {
        return this.OIO_ISEXPANSION;
    }

    public OWLAnnotation getExpansionMarkerAnnotation() {
        return this.expansionMarkerAnnotation;
    }

    protected AbstractMacroExpansionVisitor(OWLOntology ontology, boolean shouldAddExpansionMarker) {
        this(ontology);
        this.shouldAddExpansionMarker = shouldAddExpansionMarker;
    }

    protected AbstractMacroExpansionVisitor(OWLOntology inputOntology) {
        super(null);
        String str;
        OWLAnnotationValue v;
        this.dataFactory = inputOntology.getOWLOntologyManager().getOWLDataFactory();
        this.expandExpressionMap = new HashMap<IRI, String>();
        this.expandAssertionToMap = new HashMap<IRI, String>();
        OWLAnnotationProperty expandExpressionAP = this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000424.getIRI());
        OWLAnnotationProperty expandAssertionAP = this.dataFactory.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0000425.getIRI());
        this.OIO_ISEXPANSION = this.dataFactory.getOWLAnnotationProperty(IRI.create((String)"http://www.geneontology.org/formats/oboInOwl#", (String)"is_expansion"));
        this.expansionMarkerAnnotation = this.dataFactory.getOWLAnnotation(this.OIO_ISEXPANSION, (OWLAnnotationValue)this.dataFactory.getOWLLiteral(true));
        for (OWLObjectProperty p : inputOntology.getObjectPropertiesInSignature()) {
            for (OWLOntology o : inputOntology.getImportsClosure()) {
                for (OWLAnnotation a : Searcher.annotationObjects((Collection)o.getAnnotationAssertionAxioms((OWLAnnotationSubject)p.getIRI()), (OWLAnnotationProperty)expandExpressionAP)) {
                    v = a.getValue();
                    if (!(v instanceof OWLLiteral)) continue;
                    str = ((OWLLiteral)v).getLiteral();
                    LOG.info("mapping {} to {}", (Object)p, (Object)str);
                    this.expandExpressionMap.put(p.getIRI(), str);
                }
            }
        }
        for (OWLObjectProperty p : inputOntology.getAnnotationPropertiesInSignature(Imports.EXCLUDED)) {
            for (OWLOntology o : inputOntology.getImportsClosure()) {
                for (OWLAnnotation a : Searcher.annotationObjects((Collection)o.getAnnotationAssertionAxioms((OWLAnnotationSubject)p.getIRI()), (OWLAnnotationProperty)expandAssertionAP)) {
                    v = a.getValue();
                    if (!(v instanceof OWLLiteral)) continue;
                    str = ((OWLLiteral)v).getLiteral();
                    LOG.info("assertion mapping {} to {}", (Object)p, (Object)str);
                    this.expandAssertionToMap.put(p.getIRI(), str);
                }
            }
        }
    }

    public OWLClassExpression visit(@Nonnull OWLObjectIntersectionOf ce) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLClassExpression op : ce.getOperands()) {
            ops.add(op.accept((OWLClassExpressionVisitorEx)this));
        }
        return this.dataFactory.getOWLObjectIntersectionOf(ops);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectUnionOf ce) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLClassExpression op : ce.getOperands()) {
            ops.add(op.accept((OWLClassExpressionVisitorEx)this));
        }
        return this.dataFactory.getOWLObjectUnionOf(ops);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectComplementOf ce) {
        return this.dataFactory.getOWLObjectComplementOf((OWLClassExpression)ce.getOperand().accept((OWLClassExpressionVisitorEx)this));
    }

    @Nonnull
    public OWLClassExpression visit(@Nonnull OWLObjectSomeValuesFrom ce) {
        OWLClassExpression filler = (OWLClassExpression)ce.getFiller();
        OWLObjectPropertyExpression p = ce.getProperty();
        OWLClassExpression result = null;
        if (p instanceof OWLObjectProperty) {
            result = this.expandOWLObjSomeVal(filler, p);
        }
        if (result == null) {
            result = this.dataFactory.getOWLObjectSomeValuesFrom(ce.getProperty(), (OWLClassExpression)filler.accept((OWLClassExpressionVisitorEx)this));
        }
        return result;
    }

    @Nullable
    protected abstract OWLClassExpression expandOWLObjSomeVal(@Nonnull OWLClassExpression var1, @Nonnull OWLObjectPropertyExpression var2);

    @Nonnull
    public OWLClassExpression visit(@Nonnull OWLObjectHasValue ce) {
        OWLClassExpression result = null;
        OWLIndividual filler = (OWLIndividual)ce.getFiller();
        OWLObjectPropertyExpression p = ce.getProperty();
        if (p instanceof OWLObjectProperty) {
            result = this.expandOWLObjHasVal(ce, filler, p);
        }
        if (result == null) {
            result = this.dataFactory.getOWLObjectHasValue(ce.getProperty(), filler);
        }
        return result;
    }

    @Nullable
    protected abstract OWLClassExpression expandOWLObjHasVal(@Nonnull OWLObjectHasValue var1, @Nonnull OWLIndividual var2, @Nonnull OWLObjectPropertyExpression var3);

    public OWLClassExpression visit(@Nonnull OWLObjectAllValuesFrom ce) {
        return (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectMinCardinality ce) {
        OWLClassExpression filler = (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        return this.dataFactory.getOWLObjectMinCardinality(ce.getCardinality(), ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectExactCardinality ce) {
        return (OWLClassExpression)ce.asIntersectionOfMinMax().accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(@Nonnull OWLObjectMaxCardinality ce) {
        OWLClassExpression filler = (OWLClassExpression)((OWLClassExpression)ce.getFiller()).accept((OWLClassExpressionVisitorEx)this);
        return this.dataFactory.getOWLObjectMaxCardinality(ce.getCardinality(), ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLDataSomeValuesFrom ce) {
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataSomeValuesFrom(ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLDataAllValuesFrom ce) {
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataAllValuesFrom(ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLDataHasValue ce) {
        return (OWLClassExpression)ce.asSomeValuesFrom().accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(@Nonnull OWLDataExactCardinality ce) {
        return (OWLClassExpression)ce.asIntersectionOfMinMax().accept((OWLClassExpressionVisitorEx)this);
    }

    public OWLClassExpression visit(@Nonnull OWLDataMaxCardinality ce) {
        int card = ce.getCardinality();
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataMaxCardinality(card, ce.getProperty(), filler);
    }

    public OWLClassExpression visit(@Nonnull OWLDataMinCardinality ce) {
        int card = ce.getCardinality();
        OWLDataRange filler = (OWLDataRange)((OWLDataRange)ce.getFiller()).accept((OWLDataVisitorEx)this);
        return this.dataFactory.getOWLDataMinCardinality(card, ce.getProperty(), filler);
    }

    public OWLDataRange visit(@Nonnull OWLDataOneOf node) {
        HashSet<OWLDataOneOf> oneOfs = new HashSet<OWLDataOneOf>();
        for (OWLLiteral lit : node.getValues()) {
            oneOfs.add(this.dataFactory.getOWLDataOneOf(new OWLLiteral[]{lit}));
        }
        return (OWLDataRange)this.dataFactory.getOWLDataUnionOf(oneOfs).accept((OWLDataVisitorEx)this);
    }

    public OWLDataRange visit(@Nonnull OWLDataIntersectionOf node) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLDataRange op : node.getOperands()) {
            ops.add(op.accept((OWLDataVisitorEx)this));
        }
        return this.dataFactory.getOWLDataIntersectionOf(ops);
    }

    public OWLDataRange visit(@Nonnull OWLDataUnionOf node) {
        HashSet<Object> ops = new HashSet<Object>();
        for (OWLDataRange op : node.getOperands()) {
            ops.add(op.accept((OWLDataVisitorEx)this));
        }
        return this.dataFactory.getOWLDataUnionOf(ops);
    }

    public OWLAxiom visit(@Nonnull OWLSubClassOfAxiom axiom) {
        OWLClassExpression subClass = axiom.getSubClass();
        OWLClassExpression newSubclass = (OWLClassExpression)subClass.accept((OWLClassExpressionVisitorEx)this);
        OWLClassExpression superClass = axiom.getSuperClass();
        OWLClassExpression newSuperclass = (OWLClassExpression)superClass.accept((OWLClassExpressionVisitorEx)this);
        if (subClass.equals(newSubclass) && superClass.equals(newSuperclass)) {
            return axiom;
        }
        return this.dataFactory.getOWLSubClassOfAxiom(newSubclass, newSuperclass, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    @Nonnull
    public Set<OWLAnnotation> getAnnotationsWithOptionalExpansionMarker(OWLAxiom axiom) {
        if (this.shouldAddExpansionMarker) {
            LinkedHashSet<OWLAnnotation> annotations = new LinkedHashSet<OWLAnnotation>(axiom.getAnnotations());
            annotations.add(this.expansionMarkerAnnotation);
            return annotations;
        }
        return axiom.getAnnotations();
    }

    public OWLAxiom visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        HashSet<OWLClassExpression> ops = new HashSet<OWLClassExpression>();
        boolean sawChange = false;
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            OWLClassExpression newOp = (OWLClassExpression)op.accept((OWLClassExpressionVisitorEx)this);
            ops.add(newOp);
            if (op.equals(newOp)) continue;
            sawChange = true;
        }
        if (sawChange) {
            return this.dataFactory.getOWLDisjointClassesAxiom(ops, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
        }
        return axiom;
    }

    public OWLAxiom visit(@Nonnull OWLDisjointUnionAxiom axiom) {
        HashSet<OWLClassExpression> newOps = new HashSet<OWLClassExpression>();
        boolean sawChange = false;
        for (OWLClassExpression op : axiom.getClassExpressions()) {
            OWLClassExpression newOp = (OWLClassExpression)op.accept((OWLClassExpressionVisitorEx)this);
            newOps.add(newOp);
            if (op.equals(newOp)) continue;
            sawChange = true;
        }
        if (!sawChange) {
            return axiom;
        }
        return this.dataFactory.getOWLDisjointUnionAxiom(axiom.getOWLClass(), newOps, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLDataPropertyDomainAxiom axiom) {
        OWLClassExpression newDomain;
        OWLClassExpression domain = axiom.getDomain();
        if (domain.equals(newDomain = (OWLClassExpression)domain.accept((OWLClassExpressionVisitorEx)this))) {
            return axiom;
        }
        return this.dataFactory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)axiom.getProperty(), newDomain, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLObjectPropertyDomainAxiom axiom) {
        OWLClassExpression newDomain;
        OWLClassExpression domain = axiom.getDomain();
        if (domain.equals(newDomain = (OWLClassExpression)domain.accept((OWLClassExpressionVisitorEx)this))) {
            return axiom;
        }
        return this.dataFactory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)axiom.getProperty(), newDomain, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLClassExpression newRange;
        OWLClassExpression range = (OWLClassExpression)axiom.getRange();
        if (range.equals(newRange = (OWLClassExpression)range.accept((OWLClassExpressionVisitorEx)this))) {
            return axiom;
        }
        return this.dataFactory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)axiom.getProperty(), newRange, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
        OWLDataRange newRange;
        OWLDataRange range = (OWLDataRange)axiom.getRange();
        if (range.equals(newRange = (OWLDataRange)range.accept((OWLDataVisitorEx)this))) {
            return axiom;
        }
        return this.dataFactory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)axiom.getProperty(), newRange, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
    }

    public OWLAxiom visit(@Nonnull OWLClassAssertionAxiom axiom) {
        OWLClassExpression newClassExpression;
        OWLClassExpression classExpression = axiom.getClassExpression();
        if (classExpression.isAnonymous() && !classExpression.equals(newClassExpression = (OWLClassExpression)classExpression.accept((OWLClassExpressionVisitorEx)this))) {
            return this.dataFactory.getOWLClassAssertionAxiom(newClassExpression, axiom.getIndividual(), this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
        }
        return axiom;
    }

    public OWLAxiom visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
        HashSet<OWLClassExpression> newExpressions = new HashSet<OWLClassExpression>();
        boolean sawChange = false;
        for (OWLClassExpression expression : axiom.getClassExpressions()) {
            OWLClassExpression newExpression = (OWLClassExpression)expression.accept((OWLClassExpressionVisitorEx)this);
            newExpressions.add(newExpression);
            if (expression.equals(newExpression)) continue;
            sawChange = true;
        }
        if (sawChange) {
            return this.dataFactory.getOWLEquivalentClassesAxiom(newExpressions, this.getAnnotationsWithOptionalExpansionMarker((OWLAxiom)axiom));
        }
        return axiom;
    }

    public OWLClassExpression visit(OWLClass ce) {
        return ce;
    }

    public OWLClassExpression visit(OWLObjectHasSelf ce) {
        return ce;
    }

    public OWLClassExpression visit(OWLObjectOneOf ce) {
        return ce;
    }

    public OWLDataRange visit(OWLDatatype node) {
        return node;
    }

    public OWLDataRange visit(OWLDataComplementOf node) {
        return node;
    }

    public OWLAxiom visit(OWLHasKeyAxiom axiom) {
        return axiom;
    }

    public OWLDataRange visit(OWLDatatypeRestriction node) {
        return node;
    }

    public OWLAxiom visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLReflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDifferentIndividualsAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDisjointDataPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDisjointObjectPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLObjectPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubObjectPropertyOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDeclarationAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLAnnotationAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSymmetricObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLFunctionalDataPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLEquivalentDataPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDataPropertyAssertionAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLTransitiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubDataPropertyOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSameIndividualAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubPropertyChainOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLInverseObjectPropertiesAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(SWRLRule rule) {
        return rule;
    }

    public OWLAxiom visit(OWLAnnotationPropertyDomainAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLAnnotationPropertyRangeAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        return axiom;
    }

    public OWLAxiom visit(OWLDatatypeDefinitionAxiom axiom) {
        return axiom;
    }
}

