/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.console;

import de.tudresden.inf.lat.jcel.owlapi.console.OWLInferredOntologyWrapper;
import de.tudresden.inf.lat.jcel.owlapi.console.OutputStreamHandler;
import de.tudresden.inf.lat.jcel.owlapi.console.TimeOutMonitor;
import de.tudresden.inf.lat.jcel.owlapi.main.JcelReasoner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.functional.renderer.OWLFunctionalSyntaxRenderer;
import org.semanticweb.owlapi.io.AbstractOWLRenderer;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.krss2.renderer.KRSS2OWLSyntaxRenderer;
import org.semanticweb.owlapi.krss2.renderer.KRSS2SyntaxRenderer;
import org.semanticweb.owlapi.krss2.renderer.KRSSSyntaxRenderer;
import org.semanticweb.owlapi.latex.renderer.LatexRenderer;
import org.semanticweb.owlapi.manchestersyntax.renderer.ManchesterOWLSyntaxRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.owlxml.renderer.OWLXMLRenderer;
import org.semanticweb.owlapi.reasoner.InferenceType;

public class ConsoleStarter {
    public static final String cmdClassification = "classification";
    public static final String cmdConsistency = "consistency";
    public static final String cmdEntailment = "entailment";
    public static final String cmdQuery = "query";
    public static final String cmdSat = "sat";
    public static final String cmdSatisfiability = "satisfiability ";
    private static final String errorSuffix = "_err";
    public static final String licenseInfo = "Copyright (C) 2009-2014 Julian Mendez\nLicenses:\n  GNU Lesser General Public License version 3 <http://www.gnu.org/licenses/lgpl.txt>\n  Apache License, Version 2.0 <http://www.apache.org/licenses/LICENSE-2.0.txt>\nThis is free software: you are free to change and redistribute it.\njcel is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY.\n";
    private static final Logger logger = Logger.getLogger("de.tudresden.inf.lat.jcel");
    private static final String msgPartCompleted = "Completed ";
    private static final String msgPartOn = " on ";
    private static final String msgPartOperationTime = "Operation time: ";
    private static final String msgPartStarted = "Started ";
    public static final String optClassURI = "--classuri=";
    public static final String optConclusion = "--conclusion=";
    public static final String optHelp = "--help";
    public static final String optLogLevel = "--loglevel=";
    public static final String optOntology = "--ontology=";
    public static final String optOperation = "--operation=";
    public static final String optOutput = "--output=";
    public static final String optRenderer = "--renderer=";
    public static final String optTimeOut = "--timeout=";
    public static final String optVerbose = "--verbose";
    public static final String optVersion = "--version";
    public static final String rendererFunctional = "functional";
    public static final String rendererKRSS = "krss";
    public static final String rendererKRSS2 = "krss2";
    public static final String rendererKRSS2OWL = "krss2owl";
    public static final String rendererLatex = "latex";
    public static final String rendererManchester = "manchester";
    public static final String rendererXML = "xml";
    public static final String versionInfo = "jcel 0.24.1";
    private final String minihelp = "\nusage: java -jar jcel.jar <operation> <ontologyFile> <output> [<classURI>] [options]...\n\n\n<operation>:\n   consistency               determine whether the given ontology is consistent\n   sat                       determine whether the given class (<classURI>) is satisfiable with respect to the given ontology\n   classification            compute the class hierarchy and the object property hierarchy of the given ontology\n   entailment                determine whether the given ontology entails the given conclusion\n\n<ontologyFile>               ontology to be classified (or premise ontology)\n\n<output>                     output with the inferred data\n\n<classURI>                   (only for sat) URI of the class to check satisfiability\n\n\nthe available options are:\n   --conclusion=FILE         conclusion ontology\n   --renderer=RENDERER       renderer for the class hierarchy computed by the classification operation\n   --timeout=MILLISECONDS    force a time-out after a given number of milliseconds\n   --loglevel=LEVEL          log level\n   --verbose                 run verbose mode\n   --help                    display this help\n   --version                 output version\n\nthese options override the main arguments:\n   --operation=OPERATION     select an operation to execute\n   --ontology=FILE           ontology to be classified (or premise ontology)\n   --output=FILE             output with the inferred data\n   --classuri=CLASS_URI      (only for sat) URI of the class to check satisfiability\n\nthe types are:\n   CLASS_URI                 a class URI, e.g.: https://www.w3.org/2002/07/owl#Thing\n   FILE                      a file name, e.g.: /tmp/inputOntology.owl\n   LEVEL                     a " + Level.class.getName() + " number or string, e.g. " + Level.INFO.intValue() + " or  \n                             " + Level.OFF.getName() + " | " + Level.SEVERE.getName() + " | " + Level.WARNING.getName() + " | " + Level.INFO.getName() + " | " + Level.CONFIG.getName() + " | " + Level.FINE.getName() + " | " + Level.FINER.getName() + " | " + Level.FINEST.getName() + " | " + Level.ALL.getName() + "\n   MILLISECONDS              a natural number, e.g.: 300000\n   OPERATION                 " + "consistency" + " | " + "sat" + " | " + "classification" + " | " + "entailment" + "\n   RENDERER                  " + "functional" + " | " + "krss" + " | " + "krss2" + " | " + "krss2owl" + " | " + "latex" + " | " + "manchester" + " | " + "xml" + "\n\n\n\n";
    private long timeOut = 0L;
    private boolean timeOutMode = false;
    private boolean verboseMode = false;
    private final PrintStream verboseModeOutput = System.out;

    public static void main(String[] args) throws OWLRendererException, OWLOntologyCreationException, SecurityException, IOException {
        Objects.requireNonNull(args);
        new ConsoleStarter().start(args);
    }

    public boolean checkConsistency(File ontologyFile) throws OWLOntologyCreationException {
        Objects.requireNonNull(ontologyFile);
        JcelReasoner reasoner = this.createReasoner(ontologyFile);
        OWLDataFactory dataFactory = reasoner.getRootOntology().getOWLOntologyManager().getOWLDataFactory();
        boolean ret = !reasoner.getEquivalentClasses((OWLClassExpression)dataFactory.getOWLThing()).contains((OWLObject)dataFactory.getOWLNothing());
        return ret;
    }

    public boolean checkEntailment(File premiseFile, File conclusionFile) throws OWLOntologyCreationException, OWLRendererException, FileNotFoundException {
        Objects.requireNonNull(premiseFile);
        Objects.requireNonNull(conclusionFile);
        logger.fine("starting jcel console ...");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        logger.fine("loading premise ontology using the OWL API ...");
        OWLOntology premiseOntology = manager.loadOntologyFromOntologyDocument(premiseFile);
        logger.fine("loading conclusion ontology using the OWL API ...");
        OWLOntology conclusionOntology = manager.loadOntologyFromOntologyDocument(conclusionFile);
        logger.fine("starting reasoner ...");
        JcelReasoner reasoner = new JcelReasoner(premiseOntology, false);
        logger.fine("precomputing inferences ...");
        reasoner.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        boolean ret = conclusionOntology.getAxioms().stream().allMatch(axiom -> reasoner.isEntailed((OWLAxiom)axiom));
        logger.fine("jcel console finished.");
        return ret;
    }

    public boolean checkSatisfiability(File ontologyFile, IRI conceptIRI) throws OWLOntologyCreationException {
        Objects.requireNonNull(ontologyFile);
        Objects.requireNonNull(conceptIRI);
        JcelReasoner reasoner = this.createReasoner(ontologyFile);
        OWLDataFactory dataFactory = reasoner.getRootOntology().getOWLOntologyManager().getOWLDataFactory();
        boolean ret = !reasoner.getEquivalentClasses((OWLClassExpression)dataFactory.getOWLClass(conceptIRI)).contains((OWLObject)dataFactory.getOWLNothing());
        return ret;
    }

    public void computeClassification(File ontologyFile, File inferredFile, AbstractOWLRenderer renderer) throws OWLOntologyCreationException, OWLRendererException, FileNotFoundException {
        Objects.requireNonNull(ontologyFile);
        Objects.requireNonNull(inferredFile);
        JcelReasoner reasoner = this.createReasoner(ontologyFile);
        logger.fine("precomputing inferences ...");
        reasoner.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        logger.fine("generating output ...");
        OWLInferredOntologyWrapper inferredOntology = new OWLInferredOntologyWrapper(reasoner);
        renderer.render(inferredOntology.getOWLOntology(), (OutputStream)new FileOutputStream(inferredFile));
        logger.fine("jcel console finished.");
    }

    public JcelReasoner createReasoner(File ontologyFile) throws OWLOntologyCreationException {
        Objects.requireNonNull(ontologyFile);
        logger.fine("starting jcel console ...");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        logger.fine("loading ontology using the OWL API ...");
        OWLOntology ontology = manager.loadOntologyFromOntologyDocument(ontologyFile);
        logger.fine("starting reasoner ...");
        long wallClockTimeBeginning = new Date().getTime();
        JcelReasoner ret = new JcelReasoner(ontology, false);
        long wallClockTimeMidPoint = new Date().getTime();
        TimeOutMonitor monitor = new TimeOutMonitor(ret, this.timeOut - (wallClockTimeMidPoint - wallClockTimeBeginning));
        if (this.timeOutMode) {
            monitor.start();
        }
        logger.fine("precomputing inferences ...");
        ret.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        long wallClockTimeEnd = new Date().getTime();
        if (this.timeOutMode) {
            monitor.interrupt();
        }
        if (this.verboseMode) {
            this.verboseModeOutput.println(msgPartOperationTime + (wallClockTimeEnd - wallClockTimeBeginning));
        }
        return ret;
    }

    public Mode parseMode(String argument) {
        Objects.requireNonNull(argument);
        Mode mode = Mode.NOTHING;
        if (argument.equals(cmdClassification)) {
            mode = Mode.CLASSIFICATION;
        } else if (argument.equals(cmdConsistency)) {
            mode = Mode.CONSISTENCY;
        } else if (argument.equals(cmdSatisfiability) || argument.equals(cmdSat)) {
            mode = Mode.SATISFIABILITY;
        } else if (argument.equals(cmdQuery)) {
            mode = Mode.QUERY;
        } else if (argument.equals(cmdEntailment)) {
            mode = Mode.ENTAILMENT;
        } else {
            throw new IllegalArgumentException("Unrecognized mode: '" + argument + "'");
        }
        return mode;
    }

    public AbstractOWLRenderer parseRenderer(String argument) {
        Objects.requireNonNull(argument);
        KRSS2OWLSyntaxRenderer ret = null;
        if (argument.equals(rendererKRSS2OWL)) {
            ret = new KRSS2OWLSyntaxRenderer();
        } else if (argument.equals(rendererKRSS2)) {
            ret = new KRSS2SyntaxRenderer();
        } else if (argument.equals(rendererKRSS)) {
            ret = new KRSSSyntaxRenderer();
        } else if (argument.equals(rendererLatex)) {
            ret = new LatexRenderer();
        } else if (argument.equals(rendererManchester)) {
            ret = new ManchesterOWLSyntaxRenderer();
        } else if (argument.equals(rendererFunctional)) {
            ret = new OWLFunctionalSyntaxRenderer();
        } else if (argument.equals(rendererXML)) {
            ret = new OWLXMLRenderer();
        }
        return ret;
    }

    public String renderMode(Mode mode) {
        Objects.requireNonNull(mode);
        String ret = "";
        if (mode.equals((Object)Mode.CLASSIFICATION)) {
            ret = cmdClassification;
        } else if (mode.equals((Object)Mode.CONSISTENCY)) {
            ret = cmdConsistency;
        } else if (mode.equals((Object)Mode.SATISFIABILITY)) {
            ret = cmdSat;
        } else if (mode.equals((Object)Mode.QUERY)) {
            ret = cmdQuery;
        } else if (mode.equals((Object)Mode.ENTAILMENT)) {
            ret = cmdEntailment;
        } else if (mode.equals((Object)Mode.NOTHING)) {
            ret = "";
        } else {
            throw new IllegalStateException("Unrecognized mode: '" + (Object)((Object)mode) + "'");
        }
        return ret;
    }

    public void start(String[] args) throws OWLRendererException, OWLOntologyCreationException, SecurityException, IOException {
        if (args.length == 0) {
            System.out.println(this.minihelp);
        } else {
            List<String> arguments = Arrays.asList(args);
            if (arguments.contains(optHelp)) {
                System.out.println(this.minihelp);
            } else if (arguments.contains(optVersion)) {
                System.out.println(versionInfo);
                System.out.println(licenseInfo);
            } else if (arguments.size() >= 3) {
                Mode operation = null;
                File ontologyFile = null;
                File outputFile = null;
                File conclusionFile = null;
                Level logLevel = Level.OFF;
                IRI classIRI = null;
                OWLFunctionalSyntaxRenderer renderer = null;
                for (String argument : arguments) {
                    if (argument.startsWith(optOperation)) {
                        operation = this.parseMode(argument.substring(optOperation.length()));
                        continue;
                    }
                    if (argument.startsWith(optOntology)) {
                        ontologyFile = new File(argument.substring(optOntology.length()));
                        continue;
                    }
                    if (argument.startsWith(optOutput)) {
                        outputFile = new File(argument.substring(optOutput.length()));
                        continue;
                    }
                    if (argument.startsWith(optClassURI)) {
                        classIRI = IRI.create((String)argument.substring(optClassURI.length()));
                        continue;
                    }
                    if (argument.startsWith(optConclusion)) {
                        conclusionFile = new File(argument.substring(optConclusion.length()));
                        continue;
                    }
                    if (argument.startsWith(optRenderer)) {
                        renderer = this.parseRenderer(argument.substring(optRenderer.length()));
                        continue;
                    }
                    if (argument.startsWith(optLogLevel)) {
                        logLevel = Level.parse(argument.substring(optLogLevel.length()));
                        continue;
                    }
                    if (argument.startsWith(optTimeOut)) {
                        this.timeOutMode = true;
                        this.timeOut = Long.parseLong(argument.substring(optTimeOut.length()));
                        continue;
                    }
                    if (!argument.startsWith(optVerbose)) continue;
                    this.verboseMode = true;
                }
                if (Objects.isNull(operation)) {
                    operation = this.parseMode(arguments.get(0));
                }
                if (Objects.isNull(ontologyFile)) {
                    ontologyFile = new File(arguments.get(1));
                }
                if (Objects.isNull(outputFile)) {
                    outputFile = new File(arguments.get(2));
                }
                if (Objects.isNull(classIRI) && operation.equals((Object)Mode.SATISFIABILITY)) {
                    classIRI = IRI.create((String)arguments.get(3));
                }
                if (Objects.isNull(renderer)) {
                    renderer = new OWLFunctionalSyntaxRenderer();
                }
                if (Objects.nonNull(outputFile.getParentFile())) {
                    outputFile.getParentFile().mkdirs();
                }
                logger.setLevel(logLevel);
                logger.addHandler(new OutputStreamHandler(System.out));
                try {
                    if (this.verboseMode) {
                        this.verboseModeOutput.println(msgPartStarted + this.renderMode(operation) + msgPartOn + ontologyFile.getAbsolutePath());
                    }
                    if (operation == Mode.CLASSIFICATION) {
                        this.computeClassification(ontologyFile, outputFile, (AbstractOWLRenderer)renderer);
                    } else if (operation == Mode.SATISFIABILITY) {
                        this.storeInFile("" + classIRI.toString() + ", " + this.checkSatisfiability(ontologyFile, classIRI), outputFile);
                    } else if (operation == Mode.CONSISTENCY) {
                        this.storeInFile("" + this.checkConsistency(ontologyFile), outputFile);
                    } else {
                        if (operation == Mode.QUERY) {
                            throw new UnsupportedOperationException("Operation is not supported yet.");
                        }
                        if (operation == Mode.ENTAILMENT) {
                            if (Objects.isNull(conclusionFile)) {
                                throw new IllegalArgumentException("No conclusion file has been defined.");
                            }
                            this.storeInFile("" + this.checkEntailment(ontologyFile, conclusionFile), outputFile);
                        }
                    }
                    if (this.verboseMode) {
                        this.verboseModeOutput.println(msgPartCompleted + this.renderMode(operation) + msgPartOn + ontologyFile.getAbsolutePath());
                    }
                }
                catch (RuntimeException e) {
                    BufferedWriter output = new BufferedWriter(new FileWriter(outputFile.getAbsoluteFile() + errorSuffix, true));
                    output.write(e.toString());
                    output.newLine();
                    output.flush();
                    output.close();
                }
            } else {
                System.out.println(this.minihelp);
            }
        }
    }

    private void storeInFile(String output, File outputFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, true));
        writer.write(output);
        writer.newLine();
        writer.flush();
        writer.close();
    }

    public static enum Mode {
        CLASSIFICATION,
        CONSISTENCY,
        ENTAILMENT,
        NOTHING,
        QUERY,
        SATISFIABILITY;

    }
}

