/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.console;

import de.tudresden.inf.lat.jcel.owlapi.main.JcelReasoner;
import java.util.Objects;
import java.util.logging.Logger;

public class TimeOutMonitor
extends Thread {
    private static final Logger logger = Logger.getLogger(TimeOutMonitor.class.getName());
    private final JcelReasoner reasoner;
    private final long timeout;

    public TimeOutMonitor(JcelReasoner reasoner, long timeout) {
        Objects.requireNonNull(reasoner);
        this.reasoner = reasoner;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        try {
            if (this.timeout > 0L) {
                Thread.sleep(this.timeout);
            }
            this.reasoner.getReasoner().interrupt();
            logger.fine("The reasoner has timed out.");
        }
        catch (InterruptedException e) {
            logger.fine("The time-out monitor has been interrupted.");
        }
    }
}

