/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.main;

import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactoryImpl;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.owlapi.main.JcelOntologyChangeVisitorEx;
import de.tudresden.inf.lat.jcel.owlapi.main.UnsupportedReasonerOperationInJcelException;
import de.tudresden.inf.lat.jcel.owlapi.translator.Translator;
import de.tudresden.inf.lat.jcel.reasoner.main.IntegerReasoner;
import de.tudresden.inf.lat.jcel.reasoner.main.RuleBasedReasoner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.util.Version;

public class JcelReasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    private static final Logger logger = Logger.getLogger(JcelReasoner.class.getName());
    private final boolean buffering = false;
    private RuleBasedReasoner jcelCore;
    private final OWLOntologyChangeVisitorEx<Boolean> ontologyChangeVisitor = new JcelOntologyChangeVisitorEx(this);
    private final Set<OWLAxiom> pendingAxiomAdditions = new HashSet<OWLAxiom>();
    private final Set<OWLAxiom> pendingAxiomRemovals = new HashSet<OWLAxiom>();
    private final List<OWLOntologyChange> pendingChanges = new ArrayList<OWLOntologyChange>();
    private OWLReasonerConfiguration reasonerConfiguration = null;
    private final OWLOntology rootOntology;
    private final Date start = new Date();
    private final Set<AxiomType<?>> supportedAxiomTypes;
    private final Translator translator;

    public JcelReasoner(OWLOntology rootOntology, boolean buffering) {
        Objects.requireNonNull(rootOntology);
        logger.fine("configuring jcel reasoner ...");
        this.rootOntology = rootOntology;
        this.translator = new Translator(rootOntology.getOWLOntologyManager().getOWLDataFactory(), (IntegerOntologyObjectFactory)new IntegerOntologyObjectFactoryImpl());
        this.rootOntology.getOWLOntologyManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
        this.supportedAxiomTypes = this.getSupportedTypes();
        logger.fine("resetting reasoner ...");
        this.resetReasoner();
        logger.fine("jcel reasoner configured.");
    }

    public JcelReasoner(OWLOntology rootOntology, boolean buffering, OWLReasonerConfiguration configuration) {
        this(rootOntology, buffering);
        Objects.requireNonNull(configuration);
        this.reasonerConfiguration = configuration;
    }

    public boolean addAxiom(OWLAxiom axiom) {
        Objects.requireNonNull(axiom);
        logger.finer("addAxiom(" + axiom + ")");
        boolean ret = this.pendingAxiomAdditions.add(axiom);
        this.getClass();
        this.resetReasoner();
        return ret;
    }

    public void dispose() {
        logger.finer("dispose()");
        this.rootOntology.getOWLOntologyManager().removeOntologyChangeListener((OWLOntologyChangeListener)this);
        this.getReasoner().dispose();
    }

    public void flush() {
        logger.finer("flush()");
        this.pendingAxiomAdditions.clear();
        this.pendingAxiomRemovals.clear();
        this.pendingChanges.clear();
        this.resetReasoner();
        this.getReasoner().flush();
    }

    public Node<OWLClass> getBottomClassNode() {
        logger.finer("getBottomClassNode()");
        Node<OWLClass> ret = this.getTranslator().translateSC(this.getReasoner().getBottomClassNode());
        logger.finer("" + ret);
        return ret;
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        logger.finer("getBottomDataPropertyNode()");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getBottomDataPropertyNode()");
    }

    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        logger.finer("getBottomObjectPropertyNode()");
        Node<OWLObjectPropertyExpression> ret = this.getTranslator().translateSOPE(this.getReasoner().getBottomObjectPropertyNode());
        logger.finer("" + ret);
        return ret;
    }

    public BufferingMode getBufferingMode() {
        logger.finer("getBufferingMode()");
        this.getClass();
        BufferingMode ret = BufferingMode.NON_BUFFERING;
        logger.finer("" + ret);
        return ret;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty dataProperty, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(dataProperty);
        logger.finer("getDataPropertyDomains(" + dataProperty + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getDataPropertyDomains(OWLDataProperty, boolean)");
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual individual, OWLDataProperty dataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(individual);
        Objects.requireNonNull(dataProperty);
        logger.finer("getDataPropertyValues(" + individual + ", " + dataProperty + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getDataPropertyValues(OWLNamedIndividual, OWLDataProperty)");
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual individual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(individual);
        logger.finer("getDifferentIndividuals(" + individual + ")");
        NodeSet<OWLNamedIndividual> ret = this.getTranslator().translateSSI(this.getReasoner().getDifferentIndividuals(this.getTranslator().translateI(individual)));
        logger.finer("" + ret);
        return ret;
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        Objects.requireNonNull(classExpression);
        logger.finer("getDisjointClasses(" + classExpression + ")");
        NodeSet<OWLClass> ret = this.getTranslator().translateSSC(this.getReasoner().getDisjointClasses(this.getTranslator().translateCE(classExpression)));
        logger.finer("" + ret);
        return ret;
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression dataPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(dataPropertyExpression);
        logger.finer("getDisjointDataProperties(" + dataPropertyExpression + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getDisjointDataProperties(OWLDataPropertyExpression)");
    }

    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(objectPropertyExpression);
        logger.finer("getDisjointDataProperties(" + objectPropertyExpression + ")");
        NodeSet<OWLObjectPropertyExpression> ret = this.getTranslator().translateSSOPE(this.getReasoner().getDisjointObjectProperties(this.getTranslator().translateOPE(objectPropertyExpression)));
        logger.finer("" + ret);
        return ret;
    }

    Set<IntegerClass> getRegisteredClasses(Set<IntegerClass> set) {
        HashSet<IntegerClass> ret = new HashSet<IntegerClass>();
        set.stream().filter(cls -> this.getTranslator().getTranslationRepository().getOptOWLClass(cls.getId()).isPresent()).forEach(cls -> ret.add((IntegerClass)cls));
        return ret;
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression classExpression) {
        Objects.requireNonNull(classExpression);
        logger.finer("getEquivalentClasses(" + classExpression + ")");
        Node<OWLClass> ret = this.getTranslator().translateSC(this.getRegisteredClasses(this.getReasoner().getEquivalentClasses(this.getTranslator().translateCE(classExpression))));
        logger.finer("" + ret);
        return ret;
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty dataProperty) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(dataProperty);
        logger.finer("getEquivalentDataProperties(" + dataProperty + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getEquivalentDataProperties(OWLDataProperty)");
    }

    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(objectPropertyExpression);
        logger.finer("getEquivalentObjectProperties(" + objectPropertyExpression + ")");
        Node<OWLObjectPropertyExpression> ret = this.getTranslator().translateSOPE(this.getReasoner().getEquivalentObjectProperties(this.getTranslator().translateOPE(objectPropertyExpression)));
        logger.finer("" + ret);
        return ret;
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        logger.finer("getFreshEntityPolicy()");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getFreshEntityPolicy()");
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        logger.finer("getIndividualNodeSetPolicy()");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getIndividualNodeSetPolicy()");
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression classExpression, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(classExpression);
        logger.finer("getInstances(" + classExpression + ", " + direct + ")");
        NodeSet<OWLNamedIndividual> ret = this.getTranslator().translateSSI(this.getReasoner().getInstances(this.getTranslator().translateCE(classExpression), direct));
        logger.finer("" + ret);
        return ret;
    }

    private Set<ComplexIntegerAxiom> getIntegerOntology() {
        HashSet<OWLAxiom> owlAxiomSet = new HashSet<OWLAxiom>();
        owlAxiomSet.addAll(this.rootOntology.getAxioms());
        this.rootOntology.getImportsClosure().forEach(ont -> owlAxiomSet.addAll(ont.getAxioms()));
        this.translator.getTranslationRepository().addAxiomEntities(this.rootOntology);
        logger.fine("translating axioms ...");
        Set<ComplexIntegerAxiom> ret = this.translator.translateSA(owlAxiomSet);
        logger.fine("axioms translated.");
        return ret;
    }

    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(objectPropertyExpression);
        logger.finer("getInverseObjectProperties(" + objectPropertyExpression + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getInverseObjectProperties(OWLObjectPropertyExpression)");
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(objectPropertyExpression);
        logger.finer("getObjectPropertyDomains(" + objectPropertyExpression + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getObjectPropertyDomains(OWLObjectPropertyExpression, boolean)");
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(objectPropertyExpression);
        logger.finer("getObjectPropertyRanges(" + objectPropertyExpression + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getObjectPropertyRanges(OWLObjectPropertyExpression, boolean)");
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual individual, OWLObjectPropertyExpression objectPropertyExpression) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(individual);
        Objects.requireNonNull(objectPropertyExpression);
        logger.finer("getObjectPropertyValues(" + individual + ", " + objectPropertyExpression + ")");
        NodeSet<OWLNamedIndividual> ret = this.getTranslator().translateSSI(this.getReasoner().getObjectPropertyValues(this.getTranslator().translateI(individual), this.getTranslator().translateOPE(objectPropertyExpression)));
        logger.finer("" + ret);
        return ret;
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        logger.finer("getPendingAxiomAdditions()");
        Set<OWLAxiom> ret = this.pendingAxiomAdditions;
        logger.finer("" + ret);
        return Collections.unmodifiableSet(ret);
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        logger.finer("getPendingAxiomRemovals()");
        Set<OWLAxiom> ret = this.pendingAxiomRemovals;
        logger.finer("" + ret);
        return Collections.unmodifiableSet(ret);
    }

    public List<OWLOntologyChange> getPendingChanges() {
        logger.finer("getPendingChanges()");
        List<OWLOntologyChange> ret = this.pendingChanges;
        logger.finer("" + ret);
        return Collections.unmodifiableList(ret);
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        logger.finer("getPrecomputableInferenceTypes()");
        HashSet<InferenceType> ret = new HashSet<InferenceType>();
        ret.add(InferenceType.CLASS_HIERARCHY);
        ret.add(InferenceType.OBJECT_PROPERTY_HIERARCHY);
        ret.add(InferenceType.CLASS_ASSERTIONS);
        ret.add(InferenceType.OBJECT_PROPERTY_ASSERTIONS);
        ret.add(InferenceType.SAME_INDIVIDUAL);
        ret.add(InferenceType.DIFFERENT_INDIVIDUALS);
        logger.finer("" + ret);
        return ret;
    }

    public IntegerReasoner getReasoner() {
        return this.jcelCore;
    }

    public OWLReasonerConfiguration getReasonerConfiguration() {
        return this.reasonerConfiguration;
    }

    public String getReasonerName() {
        logger.finer("getReasonerName()");
        String ret = this.getReasoner().getReasonerName();
        logger.finer("" + ret);
        return ret;
    }

    public Version getReasonerVersion() {
        logger.finer("getReasonerVersion()");
        Version ret = new Version(0, 0, 0, 0);
        String versionId = this.getReasoner().getReasonerVersion();
        if (Objects.nonNull(versionId)) {
            StringTokenizer stok = new StringTokenizer(versionId, ".");
            int major = stok.hasMoreTokens() ? Integer.parseInt(stok.nextToken()) : 0;
            int minor = stok.hasMoreTokens() ? Integer.parseInt(stok.nextToken()) : 0;
            int patch = stok.hasMoreTokens() ? Integer.parseInt(stok.nextToken()) : 0;
            int build = stok.hasMoreTokens() ? Integer.parseInt(stok.nextToken()) : 0;
            ret = new Version(major, minor, patch, build);
        }
        logger.finer("" + ret);
        return ret;
    }

    public OWLOntology getRootOntology() {
        logger.finer("getRootOntology()");
        OWLOntology ret = this.rootOntology;
        logger.finer("" + ret);
        return ret;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual individual) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(individual);
        logger.finer("getSameIndividuals(" + individual + ")");
        Node<OWLNamedIndividual> ret = this.getTranslator().translateSI(this.getReasoner().getSameIndividuals(this.getTranslator().translateI(individual)));
        logger.finer("" + ret);
        return ret;
    }

    public Date getStartTime() {
        return this.start;
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression classExpression, boolean direct) {
        Objects.requireNonNull(classExpression);
        logger.finer("getSubClasses(" + classExpression + ", " + direct + ")");
        NodeSet<OWLClass> ret = this.getTranslator().translateSSC(this.getReasoner().getSubClasses(this.getTranslator().translateCE(classExpression), direct));
        logger.finer("" + ret);
        return ret;
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty dataProperty, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(dataProperty);
        logger.finer("getSubDataProperties(" + dataProperty + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getSubDataProperties(OWLDataProperty, boolean)");
    }

    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(objectPropertyExpression);
        logger.finer("getSubObjectProperties(" + objectPropertyExpression + ", " + direct + ")");
        NodeSet<OWLObjectPropertyExpression> ret = this.getTranslator().translateSSOPE(this.getReasoner().getSubObjectProperties(this.getTranslator().translateOPE(objectPropertyExpression), direct));
        logger.finer("" + ret);
        return ret;
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression classExpression, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(classExpression);
        logger.finer("getSuperClasses(" + classExpression + ", " + direct + ")");
        NodeSet<OWLClass> ret = this.getTranslator().translateSSC(this.getReasoner().getSuperClasses(this.getTranslator().translateCE(classExpression), direct));
        logger.finer("" + ret);
        return ret;
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty dataProperty, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(dataProperty);
        logger.finer("getSuperDataProperties(" + dataProperty + ", " + direct + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getSuperDataProperties(OWLDataProperty, boolean)");
    }

    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression objectPropertyExpression, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(objectPropertyExpression);
        logger.finer("getSuperObjectProperties(" + objectPropertyExpression + ", " + direct + ")");
        NodeSet<OWLObjectPropertyExpression> ret = this.getTranslator().translateSSOPE(this.getReasoner().getSuperObjectProperties(this.getTranslator().translateOPE(objectPropertyExpression), direct));
        logger.finer("" + ret);
        return ret;
    }

    private Set<AxiomType<?>> getSupportedTypes() {
        HashSet<AxiomType> ret = new HashSet<AxiomType>();
        ret.add(AxiomType.EQUIVALENT_CLASSES);
        ret.add(AxiomType.SUBCLASS_OF);
        ret.add(AxiomType.SUB_OBJECT_PROPERTY);
        return Collections.unmodifiableSet(ret);
    }

    public long getTimeOut() {
        logger.finer("getTimeOut()");
        long ret = this.getReasoner().getTimeOut();
        logger.finer("" + ret);
        return ret;
    }

    public Node<OWLClass> getTopClassNode() {
        logger.finer("getTopClassNode()");
        Node<OWLClass> ret = this.getTranslator().translateSC(this.getReasoner().getTopClassNode());
        logger.finer("" + ret);
        return ret;
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        logger.finer("getTopDataPropertyNode()");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : getTopDataPropertyNode()");
    }

    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        logger.finer("getTopObjectPropertyNode()");
        Node<OWLObjectPropertyExpression> ret = this.getTranslator().translateSOPE(this.getReasoner().getTopObjectPropertyNode());
        logger.finer("" + ret);
        return ret;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual individual, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        Objects.requireNonNull(individual);
        logger.finer("getTypes(" + individual + ", " + direct + ")");
        NodeSet<OWLClass> ret = this.getTranslator().translateSSC(this.getReasoner().getTypes(this.getTranslator().translateI(individual), direct));
        logger.finer("" + ret);
        return ret;
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        logger.finer("getUnsatisfiableClasses()");
        Node<OWLClass> ret = this.getTranslator().translateSC(this.getReasoner().getUnsatisfiableClasses());
        logger.finer("" + ret);
        return ret;
    }

    public void interrupt() {
        logger.finer("interrupt()");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : interrupt()");
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        logger.finer("isConsistent()");
        boolean ret = this.getReasoner().isConsistent();
        logger.finer("" + ret);
        return ret;
    }

    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        Objects.requireNonNull(axiom);
        logger.finer("isEntailed((OWLAxiom) " + axiom + ")");
        boolean ret = this.getReasoner().isEntailed(this.getTranslator().translateSA(Collections.singleton(axiom)));
        logger.finer("" + ret);
        return ret;
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axiomSet) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException {
        Objects.requireNonNull(axiomSet);
        logger.finer("isEntailed((Set<? extends OWLAxiom>) " + axiomSet + ")");
        HashSet<OWLAxiom> set = new HashSet<OWLAxiom>();
        axiomSet.forEach(axiom -> set.add((OWLAxiom)axiom));
        boolean ret = this.getReasoner().isEntailed(this.getTranslator().translateSA(set));
        logger.finer("" + ret);
        return ret;
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        Objects.requireNonNull(axiomType);
        logger.finer("isEntailmentCheckingSupported(" + axiomType + ")");
        boolean ret = this.supportedAxiomTypes.contains(axiomType);
        logger.finer("" + ret);
        return ret;
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        Objects.requireNonNull(inferenceType);
        logger.finer("isPrecomputed(" + inferenceType + ")");
        throw new UnsupportedReasonerOperationInJcelException("Unsupported operation : isPrecomputed()");
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) {
        Objects.requireNonNull(classExpression);
        logger.finer("isSatisfiable(" + classExpression + ")");
        boolean ret = this.getReasoner().isSatisfiable(this.getTranslator().translateCE(classExpression));
        logger.finer("" + ret);
        return ret;
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        this.pendingChanges.addAll(changes);
        changes.forEach(change -> {
            Boolean cfr_ignored_0 = (Boolean)change.accept(this.ontologyChangeVisitor);
        });
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        Objects.requireNonNull(inferenceTypes);
        logger.finer("precomputeInferences(" + inferenceTypes + ")");
        if (Objects.nonNull(this.reasonerConfiguration)) {
            this.reasonerConfiguration.getProgressMonitor().reasonerTaskStarted("Classifying");
            this.reasonerConfiguration.getProgressMonitor().reasonerTaskBusy();
        }
        logger.finer("classifying ...");
        Date start = new Date();
        this.getReasoner().classify();
        logger.finer("jcel classified in " + (new Date().getTime() - start.getTime()) + "ms");
        if (Objects.nonNull(this.reasonerConfiguration)) {
            this.reasonerConfiguration.getProgressMonitor().reasonerTaskStopped();
        }
    }

    public boolean removeAxiom(OWLAxiom axiom) {
        Objects.requireNonNull(axiom);
        logger.finer("removeAxiom(" + axiom + ")");
        boolean ret = this.pendingAxiomRemovals.add(axiom);
        this.getClass();
        this.resetReasoner();
        return ret;
    }

    private void resetReasoner() {
        this.jcelCore = new RuleBasedReasoner(this.getIntegerOntology(), this.translator.getOntologyObjectFactory());
    }
}

