/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.translator;

import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerDataTypeFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.owlapi.translator.ObjectPropertyExpressionTranslator;
import de.tudresden.inf.lat.jcel.owlapi.translator.TranslationException;
import de.tudresden.inf.lat.jcel.owlapi.translator.TranslationRepository;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;

public class ClassExpressionTranslator
implements OWLClassExpressionVisitorEx<IntegerClassExpression> {
    private final ObjectPropertyExpressionTranslator objectPropertyExpressionTranslator;

    public ClassExpressionTranslator(ObjectPropertyExpressionTranslator translator) {
        Objects.requireNonNull(translator);
        this.objectPropertyExpressionTranslator = translator;
    }

    public IntegerDataTypeFactory getDataTypeFactory() {
        return this.objectPropertyExpressionTranslator.getDataTypeFactory();
    }

    public ObjectPropertyExpressionTranslator getObjectPropertyExpressionTranslator() {
        return this.objectPropertyExpressionTranslator;
    }

    public TranslationRepository getTranslationRepository() {
        return this.objectPropertyExpressionTranslator.getTranslationRepository();
    }

    public Integer translateDataProperty(OWLDataProperty owlDataProperty) {
        Objects.requireNonNull(owlDataProperty);
        this.getTranslationRepository().addDataProperty(owlDataProperty);
        return this.getTranslationRepository().getId(owlDataProperty);
    }

    public Integer translateIndividual(OWLIndividual owlIndividual) throws TranslationException {
        Objects.requireNonNull(owlIndividual);
        this.getTranslationRepository().addNamedIndividual(owlIndividual.asOWLNamedIndividual());
        return this.getTranslationRepository().getId(owlIndividual);
    }

    public Integer translateLiteral(OWLLiteral owlLiteral) throws TranslationException {
        Objects.requireNonNull(owlLiteral);
        this.getTranslationRepository().addLiteral(owlLiteral);
        return this.getTranslationRepository().getId(owlLiteral);
    }

    public IntegerClassExpression visit(OWLClass owlClassExpression) {
        Objects.requireNonNull(owlClassExpression);
        this.getTranslationRepository().addClass(owlClassExpression);
        return this.getDataTypeFactory().createClass(this.getTranslationRepository().getId(owlClassExpression).intValue());
    }

    public IntegerClassExpression visit(OWLDataAllValuesFrom ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLDataExactCardinality ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLDataHasValue ce) {
        Objects.requireNonNull(ce);
        Integer dataPropertyId = this.getObjectPropertyExpressionTranslator().getTranslationRepository().getId(ce.getProperty().asOWLDataProperty());
        Integer literalId = this.getTranslationRepository().getId((OWLLiteral)ce.getFiller());
        return this.getDataTypeFactory().createDataHasValue(dataPropertyId.intValue(), literalId.intValue());
    }

    public IntegerClassExpression visit(OWLDataMaxCardinality ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLDataMinCardinality ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLDataSomeValuesFrom ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLObjectAllValuesFrom ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLObjectComplementOf ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLObjectExactCardinality ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLObjectHasSelf ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLObjectHasValue ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLObjectIntersectionOf ce) {
        Objects.requireNonNull(ce);
        Set operands = ce.getOperands();
        HashSet classExpressionList = new HashSet();
        operands.forEach(elem -> classExpressionList.add(elem.accept((OWLClassExpressionVisitorEx)this)));
        return this.getDataTypeFactory().createObjectIntersectionOf(classExpressionList);
    }

    public IntegerClassExpression visit(OWLObjectMaxCardinality ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLObjectMinCardinality ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }

    public IntegerClassExpression visit(OWLObjectOneOf ce) {
        Objects.requireNonNull(ce);
        Set indivSet = ce.getIndividuals();
        if (indivSet.isEmpty()) {
            throw new TranslationException("It is not possible to translate ObjectOneOf with empty set.");
        }
        if (indivSet.size() > 1) {
            throw new TranslationException("It is not possible to translate ObjectOneOf with multiple individuals: '" + indivSet + "'.");
        }
        return this.getDataTypeFactory().createObjectOneOf(this.translateIndividual((OWLIndividual)indivSet.iterator().next()).intValue());
    }

    public IntegerClassExpression visit(OWLObjectSomeValuesFrom ce) {
        Objects.requireNonNull(ce);
        IntegerObjectPropertyExpression propertyExpr = (IntegerObjectPropertyExpression)ce.getProperty().accept((OWLPropertyExpressionVisitorEx)this.getObjectPropertyExpressionTranslator());
        OWLClassExpression desc = (OWLClassExpression)ce.getFiller();
        IntegerClassExpression classExpression = (IntegerClassExpression)desc.accept((OWLClassExpressionVisitorEx)this);
        return this.getDataTypeFactory().createObjectSomeValuesFrom(propertyExpr, classExpression);
    }

    public IntegerClassExpression visit(OWLObjectUnionOf ce) {
        Objects.requireNonNull(ce);
        throw TranslationException.newUnsupportedTranslationException(ce);
    }
}

