/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.io;

import com.clarkparsia.owlapi.explanation.io.ExplanationRenderer;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SimpleRenderer;

public class ConciseExplanationRenderer
implements ExplanationRenderer {
    private static final String INDENT = "   ";
    private final SimpleRenderer renderer = new SimpleRenderer();
    private PrintWriter printWriter;

    @Override
    public void startRendering(Writer writer) {
        OWLAPIPreconditions.checkNotNull((Object)writer, (String)"w cannot be null");
        this.printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    @Override
    public void render(OWLAxiom axiom, @Nonnull Set<Set<OWLAxiom>> explanations) {
        this.printWriter.println("Axiom: " + this.renderer.render((OWLObject)OWLAPIPreconditions.checkNotNull((Object)axiom, (String)"axiom cannot be null")));
        int expSize = ((Set)OWLAPIPreconditions.checkNotNull(explanations)).size();
        if (expSize == 0) {
            this.printWriter.println("Explanation: AXIOM IS NOT ENTAILED!");
            return;
        }
        if (expSize == 1) {
            this.printWriter.println("Explanation: ");
            Set<OWLAxiom> explanation = explanations.iterator().next();
            this.renderSingleExplanation(INDENT, explanation);
        } else {
            this.printWriter.println("Explanations (" + expSize + "): ");
            this.renderMultipleExplanations(explanations);
        }
        this.printWriter.println();
    }

    private void renderMultipleExplanations(Set<Set<OWLAxiom>> explanations) {
        int count = 1;
        for (Set<OWLAxiom> exp : explanations) {
            String header = count++ + ") ";
            this.renderSingleExplanation(header, exp);
        }
    }

    private void renderSingleExplanation(String inputHeader, Set<OWLAxiom> axioms) {
        String header = inputHeader;
        boolean first = true;
        for (OWLAxiom axiom : axioms) {
            assert (axiom != null);
            if (first) {
                first = false;
            } else {
                header = INDENT;
            }
            this.printWriter.println(header + this.renderer.render((OWLObject)axiom));
        }
    }

    @Override
    public void endRendering() {
        this.printWriter.flush();
    }
}

