/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectInverseOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyExpressionImpl;

public class OWLObjectPropertyImpl
extends OWLObjectPropertyExpressionImpl
implements OWLObjectProperty {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final IRI iri;
    private final boolean builtin;

    @Override
    protected int index() {
        return 1002;
    }

    public OWLObjectPropertyImpl(@Nonnull IRI iri) {
        this.iri = (IRI)OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        this.builtin = iri.equals((Object)OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI()) || iri.equals((Object)OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
    }

    @Nonnull
    public OWLObjectInverseOf getInverseProperty() {
        return new OWLObjectInverseOfImpl(this);
    }

    @Nonnull
    public OWLObjectProperty getNamedProperty() {
        return this;
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    public boolean isTopEntity() {
        return this.isOWLTopObjectProperty();
    }

    @Override
    public boolean isBottomEntity() {
        return this.isOWLBottomObjectProperty();
    }

    public EntityType<?> getEntityType() {
        return EntityType.OBJECT_PROPERTY;
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.builtin;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLObjectProperty)) {
            return false;
        }
        return ((OWLObjectProperty)obj).getIRI().equals((Object)this.iri);
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLObjectProperty)this);
    }

    public void accept(OWLPropertyExpressionVisitor visitor) {
        visitor.visit((OWLObjectProperty)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLObjectProperty)this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLObjectProperty)this);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLObjectProperty)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLObjectProperty)this);
    }

    public <O> O accept(OWLPropertyExpressionVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLObjectProperty)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLObjectProperty)this);
    }

    public OWLObjectProperty asOWLObjectProperty() {
        return this;
    }

    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not a data property!");
    }

    public OWLDatatype asOWLDatatype() {
        throw new OWLRuntimeException("Not a data type!");
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not an individual!");
    }

    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not an OWLClass!");
    }

    public boolean isOWLClass() {
        return false;
    }

    public boolean isOWLDataProperty() {
        return false;
    }

    public boolean isOWLDatatype() {
        return false;
    }

    public boolean isOWLNamedIndividual() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return true;
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new OWLRuntimeException("Not an annotation property");
    }

    public boolean isOWLAnnotationProperty() {
        return false;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return this.iri.compareTo((OWLObject)((OWLObjectProperty)object).getIRI());
    }

    public boolean isOWLTopObjectProperty() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI());
    }

    public boolean isOWLBottomObjectProperty() {
        return this.iri.equals((Object)OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
    }

    public boolean isOWLTopDataProperty() {
        return false;
    }

    public boolean isOWLBottomDataProperty() {
        return false;
    }
}

