/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;
import org.apache.jena.riot.system.PrefixMapFactory;

public class PrefixMapExtended
extends PrefixMapBase {
    protected PrefixMap parent;
    protected PrefixMap local;

    public PrefixMapExtended(PrefixMap ext) {
        if (ext == null) {
            throw new IllegalArgumentException("Prefix Map to extend cannot be null");
        }
        this.parent = ext;
        this.local = PrefixMapFactory.create();
    }

    @Override
    public void add(String prefix, String iri) {
        prefix = this.canonicalPrefix(prefix);
        this.local.add(prefix, iri);
    }

    @Override
    public void delete(String prefix) {
        prefix = this.canonicalPrefix(prefix);
        this.local.delete(prefix);
        if (this.parent.containsPrefix(prefix)) {
            Log.warn((Object)this, (String)"Attempt to delete a prefix in the parent");
        }
    }

    @Override
    public void clear() {
        this.local.clear();
    }

    @Override
    public String expand(String prefix, String localName) {
        String x = this.local.expand(prefix = this.canonicalPrefix(prefix), localName);
        if (x != null) {
            return x;
        }
        return this.parent.expand(prefix, localName);
    }

    @Override
    public Map<String, String> getMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.putAll(this.parent.getMapping());
        mapping.putAll(this.local.getMapping());
        return Collections.unmodifiableMap(mapping);
    }

    @Override
    public boolean containsPrefix(String prefix) {
        return this.local.containsPrefix(prefix) || this.parent.containsPrefix(prefix);
    }

    @Override
    public String abbreviate(String uriStr) {
        String x = this.local.abbreviate(uriStr);
        if (x != null) {
            return x;
        }
        return this.parent.abbreviate(uriStr);
    }

    @Override
    public Pair<String, String> abbrev(String uriStr) {
        Pair<String, String> p = this.local.abbrev(uriStr);
        if (p != null) {
            return p;
        }
        return this.parent.abbrev(uriStr);
    }

    @Override
    public boolean isEmpty() {
        return this.parent.isEmpty() && this.local.isEmpty();
    }

    @Override
    public int size() {
        return this.parent.size() + this.local.size();
    }
}

