/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.parsing.javacc;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.semanticweb.elk.owl.parsing.javacc.AbstractOwl2FunctionalStyleParserTokenManager;
import org.semanticweb.elk.owl.parsing.javacc.LexerBatch;
import org.semanticweb.elk.owl.parsing.javacc.LexerError;
import org.semanticweb.elk.owl.parsing.javacc.LexerMessage;
import org.semanticweb.elk.owl.parsing.javacc.LexerMessageVisitor;
import org.semanticweb.elk.owl.parsing.javacc.Token;
import org.semanticweb.elk.owl.parsing.javacc.TokenMgrError;

class ConcurrentJavaCCLexer
extends AbstractOwl2FunctionalStyleParserTokenManager {
    private static final int DEFAULT_BATCH_LENGTH_ = 4096;
    private final BlockingQueue<LexerMessage> messagePipe_ = new SynchronousQueue<LexerMessage>();
    private final LexerMessageVisitor messageProcessor_ = new LexerMessageProcessor();
    private LexerBatch lastBatch_ = null;
    private int batchSize_ = 0;
    private int pos_ = 0;
    private Token lastToken_ = null;

    public ConcurrentJavaCCLexer(AbstractOwl2FunctionalStyleParserTokenManager nativeLexer) {
        super(null);
        Thread lexerThread = new Thread((Runnable)new Lexer(nativeLexer, this.messagePipe_, 4096), "elk-lexer-thread");
        lexerThread.setDaemon(true);
        lexerThread.start();
    }

    @Override
    public Token getNextToken() {
        while (true) {
            if (this.pos_ < this.batchSize_) {
                this.lastToken_ = (Token)this.lastBatch_.get(this.pos_++);
                return this.lastToken_;
            }
            try {
                this.messagePipe_.take().accept(this.messageProcessor_);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new Error("ELK lexer was interrupted", e);
            }
            this.batchSize_ = this.lastBatch_.size();
            this.pos_ = 0;
        }
    }

    private static class Lexer
    implements Runnable {
        private final AbstractOwl2FunctionalStyleParserTokenManager lexer_;
        private final BlockingQueue<LexerMessage> messagePipe_;
        private final int batchLength_;
        private LexerBatch nextBatch_;

        Lexer(AbstractOwl2FunctionalStyleParserTokenManager lexer, BlockingQueue<LexerMessage> messagePipe, int batchLength) {
            this.lexer_ = lexer;
            this.messagePipe_ = messagePipe;
            this.batchLength_ = batchLength;
            this.nextBatch_ = new LexerBatch(this.batchLength_);
        }

        @Override
        public void run() {
            try {
                Token nextToken;
                do {
                    nextToken = this.lexer_.getNextToken();
                    this.nextBatch_.add(nextToken);
                    if (this.nextBatch_.size() != this.batchLength_) continue;
                    this.messagePipe_.put(this.nextBatch_);
                    this.nextBatch_ = new LexerBatch(this.batchLength_);
                } while (nextToken.kind != 0);
                this.messagePipe_.put(this.nextBatch_);
                return;
            }
            catch (InterruptedException e) {
                while (true) {
                    try {
                        this.messagePipe_.put(new LexerError(new Error("ELK lexer was interrupted", e)));
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (TokenMgrError err) {
                while (true) {
                    try {
                        this.messagePipe_.put(new LexerError(err));
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private class LexerMessageProcessor
    implements LexerMessageVisitor {
        private LexerMessageProcessor() {
        }

        @Override
        public void visit(LexerBatch batch) {
            ConcurrentJavaCCLexer.this.lastBatch_ = batch;
        }

        @Override
        public void visit(LexerError error) {
            throw error.getError();
        }
    }
}

