/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObject;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectCache;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.MainAxiomIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.PositiveSubsumer;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.LinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.collections.chains.AbstractChain;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class DirectIndex
implements ModifiableOntologyIndex {
    protected static final Logger LOGGER_ = Logger.getLogger(DirectIndex.class);
    final IndexedClass indexedOwlThing;
    final IndexedClass indexedOwlNothing;
    final IndexedObjectCache objectCache;
    private ChainableRule<Context> contextInitRules_ = new ContextRootInitializationRule();
    private final Set<IndexedObjectProperty> reflexiveObjectProperties_;

    public DirectIndex(IndexedObjectCache objectCache) {
        this.objectCache = objectCache;
        MainAxiomIndexerVisitor tmpAxiomInserter = new MainAxiomIndexerVisitor(this, true);
        this.indexedOwlThing = tmpAxiomInserter.indexClassDeclaration((ElkClass)PredefinedElkClass.OWL_THING);
        this.indexedOwlNothing = tmpAxiomInserter.indexClassDeclaration((ElkClass)PredefinedElkClass.OWL_NOTHING);
        this.reflexiveObjectProperties_ = new ArrayHashSet(64);
    }

    public DirectIndex() {
        this(new IndexedObjectCache());
    }

    @Override
    public LinkRule<Context> getContextInitRuleHead() {
        return this.contextInitRules_;
    }

    @Override
    public Collection<IndexedClassExpression> getIndexedClassExpressions() {
        return this.objectCache.indexedClassExpressionLookup;
    }

    @Override
    public Collection<IndexedClass> getIndexedClasses() {
        return new AbstractCollection<IndexedClass>(){

            @Override
            public Iterator<IndexedClass> iterator() {
                return Operations.filter(DirectIndex.this.getIndexedClassExpressions(), IndexedClass.class).iterator();
            }

            @Override
            public int size() {
                return DirectIndex.this.objectCache.indexedClassCount;
            }
        };
    }

    @Override
    public Collection<IndexedIndividual> getIndexedIndividuals() {
        return new AbstractCollection<IndexedIndividual>(){

            @Override
            public Iterator<IndexedIndividual> iterator() {
                return Operations.filter(DirectIndex.this.getIndexedClassExpressions(), IndexedIndividual.class).iterator();
            }

            @Override
            public int size() {
                return DirectIndex.this.objectCache.indexedIndividualCount;
            }
        };
    }

    @Override
    public Collection<IndexedPropertyChain> getIndexedPropertyChains() {
        return this.objectCache.indexedPropertyChainLookup;
    }

    @Override
    public Collection<IndexedObjectProperty> getIndexedObjectProperties() {
        return new AbstractCollection<IndexedObjectProperty>(){

            @Override
            public Iterator<IndexedObjectProperty> iterator() {
                return Operations.filter(DirectIndex.this.getIndexedPropertyChains(), IndexedObjectProperty.class).iterator();
            }

            @Override
            public int size() {
                return DirectIndex.this.objectCache.indexedObjectPropertyCount;
            }
        };
    }

    @Override
    public Collection<IndexedObjectProperty> getReflexiveObjectProperties() {
        return Collections.unmodifiableCollection(this.reflexiveObjectProperties_);
    }

    @Override
    public IndexedClass getIndexedOwlThing() {
        return this.indexedOwlThing;
    }

    @Override
    public IndexedClass getIndexedOwlNothing() {
        return this.indexedOwlNothing;
    }

    @Override
    public IndexedObjectCache getIndexedObjectCache() {
        return this.objectCache;
    }

    @Override
    public void addClass(ElkClass newClass) {
    }

    @Override
    public void removeClass(ElkClass oldClass) {
    }

    @Override
    public void addNamedIndividual(ElkNamedIndividual newIndividual) {
    }

    @Override
    public void removeNamedIndividual(ElkNamedIndividual oldIndividual) {
    }

    @Override
    public void addContextInitRule(ChainableRule<Context> newRule) {
        newRule.addTo(this.getContextInitRuleChain());
    }

    @Override
    public void removeContextInitRule(ChainableRule<Context> oldRule) {
        if (!oldRule.removeFrom(this.getContextInitRuleChain())) {
            throw new ElkUnexpectedIndexingException("Cannot remove context initialization rule " + oldRule.getName());
        }
    }

    @Override
    public void add(IndexedClassExpression target, ChainableRule<Context> rule) {
        rule.addTo(target.getCompositionRuleChain());
    }

    @Override
    public void remove(IndexedClassExpression target, ChainableRule<Context> rule) {
        if (!rule.removeFrom(target.getCompositionRuleChain())) {
            throw new ElkUnexpectedIndexingException("Cannot remove composition rule " + rule.getName() + " for " + target);
        }
    }

    @Override
    public void add(IndexedObject newObject) {
        newObject.accept(this.objectCache.inserter);
    }

    @Override
    public void remove(IndexedObject oldObject) {
        IndexedClassExpression ice;
        Context context;
        if (!oldObject.accept(this.objectCache.deletor).booleanValue()) {
            throw new ElkUnexpectedIndexingException("Cannot remove indexed object from the cache " + oldObject);
        }
        if (oldObject instanceof IndexedClassExpression && (context = (ice = (IndexedClassExpression)oldObject).getContext()) != null) {
            context.removeLinks();
        }
    }

    @Override
    public void addReflexiveProperty(IndexedObjectProperty property) {
        this.reflexiveObjectProperties_.add(property);
    }

    @Override
    public void removeReflexiveProperty(IndexedObjectProperty property) {
        if (!this.reflexiveObjectProperties_.remove(property)) {
            throw new ElkUnexpectedIndexingException("Cannot remove reflexivity of object property " + property);
        }
    }

    public Chain<ChainableRule<Context>> getContextInitRuleChain() {
        return new AbstractChain<ChainableRule<Context>>(){

            public ChainableRule<Context> next() {
                return DirectIndex.this.contextInitRules_;
            }

            public void setNext(ChainableRule<Context> tail) {
                DirectIndex.this.contextInitRules_ = tail;
            }
        };
    }

    public static class ContextRootInitializationRule
    extends ModifiableLinkImpl<ChainableRule<Context>>
    implements ChainableRule<Context> {
        public static final String NAME = "Root Introduction";
        private static final Matcher<ChainableRule<Context>, ContextRootInitializationRule> MATCHER_ = new SimpleTypeBasedMatcher(ContextRootInitializationRule.class);
        private static final ReferenceFactory<ChainableRule<Context>, ContextRootInitializationRule> FACTORY_ = new ReferenceFactory<ChainableRule<Context>, ContextRootInitializationRule>(){

            public ContextRootInitializationRule create(ChainableRule<Context> tail) {
                return new ContextRootInitializationRule(tail);
            }
        };

        private ContextRootInitializationRule(ChainableRule<Context> tail) {
            super(tail);
        }

        public ContextRootInitializationRule() {
            super(null);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Applying Root Introduction to " + context));
            }
            writer.produce(context, new PositiveSubsumer(context.getRoot()));
        }

        public boolean addTo(Chain<ChainableRule<Context>> ruleChain) {
            ContextRootInitializationRule rule = (ContextRootInitializationRule)ruleChain.find(MATCHER_);
            if (rule == null) {
                ruleChain.getCreate(MATCHER_, FACTORY_);
                return true;
            }
            return false;
        }

        public boolean removeFrom(Chain<ChainableRule<Context>> ruleChain) {
            return ruleChain.remove(MATCHER_) != null;
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, Context context) {
            visitor.visit(this, writer, context);
        }
    }
}

