/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDisjointnessAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.conclusions.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.Conclusion;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ModifiableLinkRule;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.HashSetMultimap;
import org.semanticweb.elk.util.collections.Multimap;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.collections.chains.AbstractChain;
import org.semanticweb.elk.util.concurrent.collections.ActivationStack;

public class ContextImpl
implements Context {
    private final IndexedClassExpression root_;
    volatile ContextImpl next;
    volatile ContextImpl previous;
    private final Set<IndexedClassExpression> subsumers_;
    private Multimap<IndexedPropertyChain, Context> backwardLinksByObjectProperty_ = null;
    private Map<IndexedDisjointnessAxiom, Boolean> disjointnessAxioms_;
    private ModifiableLinkRule<BackwardLink> backwardLinkRules_ = null;
    private final ActivationStack<Conclusion> toDo_;
    protected volatile boolean isSaturated = false;
    protected volatile boolean isInconsistent = false;

    public ContextImpl(IndexedClassExpression root) {
        this.root_ = root;
        this.toDo_ = new ActivationStack();
        this.subsumers_ = new ArrayHashSet(13);
    }

    @Override
    public IndexedClassExpression getRoot() {
        return this.root_;
    }

    @Override
    public void removeLinks() {
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
    }

    @Override
    public Set<IndexedClassExpression> getSubsumers() {
        return this.subsumers_;
    }

    @Override
    public boolean addSubsumer(IndexedClassExpression expression) {
        return this.subsumers_.add(expression);
    }

    @Override
    public boolean containsSubsumer(IndexedClassExpression expression) {
        return this.subsumers_.contains(expression);
    }

    @Override
    public boolean removeSubsumer(IndexedClassExpression expression) {
        return this.subsumers_.remove(expression);
    }

    @Override
    public boolean isInconsistent() {
        return this.isInconsistent;
    }

    @Override
    public boolean setInconsistent(boolean inconsistent) {
        boolean result = this.isInconsistent;
        this.isInconsistent = inconsistent;
        return result;
    }

    @Override
    public Multimap<IndexedPropertyChain, Context> getBackwardLinksByObjectProperty() {
        if (this.backwardLinksByObjectProperty_ == null) {
            return Operations.emptyMultimap();
        }
        return this.backwardLinksByObjectProperty_;
    }

    @Override
    public boolean containsBackwardLink(BackwardLink link) {
        if (this.backwardLinksByObjectProperty_ != null) {
            return this.backwardLinksByObjectProperty_.contains((Object)link.getRelation(), (Object)link.getSource());
        }
        return false;
    }

    @Override
    public boolean addDisjointnessAxiom(IndexedDisjointnessAxiom disjointnessAxiom) {
        Boolean inconsistency;
        if (this.disjointnessAxioms_ == null) {
            this.disjointnessAxioms_ = new ArrayHashMap();
        }
        if ((inconsistency = this.disjointnessAxioms_.get(disjointnessAxiom)) == null) {
            inconsistency = false;
        } else {
            if (inconsistency.booleanValue()) {
                return false;
            }
            inconsistency = true;
        }
        this.disjointnessAxioms_.put(disjointnessAxiom, inconsistency);
        return true;
    }

    @Override
    public boolean removeDisjointnessAxiom(IndexedDisjointnessAxiom axiom) {
        if (this.disjointnessAxioms_ == null) {
            return false;
        }
        Boolean inconcistency = this.disjointnessAxioms_.get(axiom);
        if (inconcistency == null) {
            return false;
        }
        if (inconcistency.booleanValue()) {
            this.disjointnessAxioms_.put(axiom, false);
        } else {
            this.disjointnessAxioms_.remove(axiom);
            if (this.disjointnessAxioms_.isEmpty()) {
                this.disjointnessAxioms_ = null;
            }
        }
        return true;
    }

    @Override
    public boolean containsDisjointnessAxiom(IndexedDisjointnessAxiom axiom) {
        if (this.disjointnessAxioms_ == null) {
            return false;
        }
        return this.disjointnessAxioms_.containsKey(axiom);
    }

    @Override
    public boolean inconsistencyDisjointnessAxiom(IndexedDisjointnessAxiom axiom) {
        Boolean inconsistency = this.disjointnessAxioms_.get(axiom);
        if (inconsistency == null) {
            return false;
        }
        return inconsistency;
    }

    @Override
    public boolean setSaturated(boolean saturated) {
        boolean result = this.isSaturated;
        this.isSaturated = saturated;
        return result;
    }

    @Override
    public boolean isSaturated() {
        return this.isSaturated;
    }

    @Override
    public boolean addBackwardLink(BackwardLink link) {
        Context source = link.getSource();
        IndexedPropertyChain relation = link.getRelation();
        if (this.backwardLinksByObjectProperty_ == null) {
            this.backwardLinksByObjectProperty_ = new HashSetMultimap();
        }
        return this.backwardLinksByObjectProperty_.add((Object)relation, (Object)source);
    }

    @Override
    public boolean removeBackwardLink(BackwardLink link) {
        boolean changed = false;
        if (this.backwardLinksByObjectProperty_ != null) {
            changed = this.backwardLinksByObjectProperty_.remove((Object)link.getRelation(), (Object)link.getSource());
            if (this.backwardLinksByObjectProperty_.isEmpty()) {
                this.backwardLinksByObjectProperty_ = null;
            }
        }
        return changed;
    }

    public AbstractChain<ModifiableLinkRule<BackwardLink>> getBackwardLinkRuleChain() {
        return new AbstractChain<ModifiableLinkRule<BackwardLink>>(){

            public ModifiableLinkRule<BackwardLink> next() {
                return ContextImpl.this.backwardLinkRules_;
            }

            public void setNext(ModifiableLinkRule<BackwardLink> tail) {
                ContextImpl.this.backwardLinkRules_ = tail;
            }
        };
    }

    public ModifiableLinkRule<BackwardLink> getBackwardLinkRuleHead() {
        return this.backwardLinkRules_;
    }

    @Override
    public boolean addToDo(Conclusion conclusion) {
        return this.toDo_.push((Object)conclusion);
    }

    @Override
    public Conclusion takeToDo() {
        return (Conclusion)this.toDo_.pop();
    }

    public String toString() {
        return this.root_.toString() + (this != this.root_.getContext() ? "[local]" : "");
    }

    @Override
    public boolean isEmpty() {
        return !(this.subsumers_ != null && !this.subsumers_.isEmpty() || this.backwardLinksByObjectProperty_ != null && !this.backwardLinksByObjectProperty_.isEmpty() || this.getBackwardLinkRuleHead() != null);
    }
}

