/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI2Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class GCI2AxiomImpl
implements GCI2Axiom {
    private final int classInSuperClass;
    private final int propertyInSuperClass;
    private final int subClass;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    GCI2AxiomImpl(int leftClassId, int rightPropertyId, int rightClassId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.subClass = leftClassId;
        this.propertyInSuperClass = rightPropertyId;
        this.classInSuperClass = rightClassId;
        this.annotations = annotations;
        this.hashCode = this.subClass + 31 * (this.propertyInSuperClass + 31 * (this.classInSuperClass + 31 * this.annotations.hashCode()));
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GCI2Axiom)) {
            return false;
        }
        GCI2Axiom other = (GCI2Axiom)obj;
        return this.getSubClass() == other.getSubClass() && this.getClassInSuperClass() == other.getClassInSuperClass() && this.getPropertyInSuperClass() == other.getPropertyInSuperClass() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(this.subClass);
        ret.add(this.classInSuperClass);
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public int getClassInSuperClass() {
        return this.classInSuperClass;
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(this.getPropertyInSuperClass());
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public int getPropertyInSuperClass() {
        return this.propertyInSuperClass;
    }

    @Override
    public int getSubClass() {
        return this.subClass;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubClassOf*");
        sbuf.append("(");
        sbuf.append(this.getSubClass());
        sbuf.append(" ");
        sbuf.append("ObjectSomeValuesFrom");
        sbuf.append("(");
        sbuf.append(this.getPropertyInSuperClass());
        sbuf.append(" ");
        sbuf.append(this.getClassInSuperClass());
        sbuf.append(")");
        sbuf.append(")");
        return sbuf.toString();
    }
}

