/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.coreontology.axiom;

import de.tudresden.inf.lat.jcel.coreontology.axiom.GCI3Axiom;
import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiomVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class GCI3AxiomImpl
implements GCI3Axiom {
    private final int classInSubClass;
    private final int propertyInSubClass;
    private final int superClass;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    GCI3AxiomImpl(int leftPropertyId, int leftClassId, int rightClassId, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(annotations);
        this.classInSubClass = leftClassId;
        this.propertyInSubClass = leftPropertyId;
        this.superClass = rightClassId;
        this.annotations = annotations;
        this.hashCode = this.classInSubClass + 31 * (this.propertyInSubClass + 31 * (this.superClass + 31 * this.annotations.hashCode()));
    }

    @Override
    public <T> T accept(NormalizedIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GCI3Axiom)) {
            return false;
        }
        GCI3Axiom other = (GCI3Axiom)obj;
        return this.getClassInSubClass() == other.getClassInSubClass() && this.getPropertyInSubClass() == other.getPropertyInSubClass() && this.getSuperClass() == other.getSuperClass() && this.getAnnotations().equals(other.getAnnotations());
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.add(this.classInSubClass);
        ret.add(this.superClass);
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public int getClassInSubClass() {
        return this.classInSubClass;
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.singleton(this.propertyInSubClass);
    }

    @Override
    public int getPropertyInSubClass() {
        return this.propertyInSubClass;
    }

    @Override
    public int getSuperClass() {
        return this.superClass;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("SubClassOf*");
        sbuf.append("(");
        sbuf.append("ObjectSomeValuesFrom");
        sbuf.append("(");
        sbuf.append(this.getPropertyInSubClass());
        sbuf.append(" ");
        sbuf.append(this.getClassInSubClass());
        sbuf.append(")");
        sbuf.append(" ");
        sbuf.append(this.getSuperClass());
        sbuf.append(")");
        return sbuf.toString();
    }
}

